/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.jms.transports.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpollSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EpollSupport.class);

    public static boolean isAvailable(TransportOptions transportOptions) {
        try {
            return transportOptions.isUseEpoll() && Epoll.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for Epoll support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadfactory) {
        return new EpollEventLoopGroup(nThreads, ioThreadfactory);
    }

    public static void createChannel(Bootstrap bootstrap) {
        bootstrap.channel(EpollSocketChannel.class);
    }
}

