/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.ValueType;

class AvroColumnator {
    private List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    private List<Integer> arrayWidths = new ArrayList<Integer>();
    private Map<Schema, Schema> seen = new IdentityHashMap<Schema, Schema>();

    public AvroColumnator(Schema schema) {
        Schema schema1 = schema;
        this.columnize(null, schema, null, false);
    }

    public ColumnMetaData[] getColumns() {
        return this.columns.toArray(new ColumnMetaData[0]);
    }

    public int[] getArrayWidths() {
        int[] result = new int[this.arrayWidths.size()];
        int i = 0;
        for (Integer width : this.arrayWidths) {
            result[i++] = width;
        }
        return result;
    }

    private void columnize(String path, Schema s, ColumnMetaData parent, boolean isArray) {
        if (AvroColumnator.isSimple(s)) {
            if (path == null) {
                path = s.getFullName();
            }
            this.addColumn((String)path, this.simpleValueType(s), parent, isArray);
            return;
        }
        if (this.seen.containsKey(s)) {
            throw new TrevniRuntimeException("Cannot shred recursive schemas: " + String.valueOf(s));
        }
        this.seen.put(s, s);
        switch (s.getType()) {
            case MAP: {
                path = path == null ? ">" : (String)path + ">";
                int start = this.columns.size();
                ColumnMetaData p = this.addColumn((String)path, ValueType.NULL, parent, true);
                this.addColumn(this.p((String)path, "key", ""), ValueType.STRING, p, false);
                this.columnize(this.p((String)path, "value", ""), s.getValueType(), p, false);
                this.arrayWidths.set(start, this.columns.size() - start);
                break;
            }
            case RECORD: {
                for (Schema.Field field : s.getFields()) {
                    this.columnize(this.p((String)path, field.name(), "#"), field.schema(), parent, isArray);
                }
                break;
            }
            case ARRAY: {
                path = path == null ? "[]" : (String)path + "[]";
                this.addArrayColumn((String)path, s.getElementType(), parent);
                break;
            }
            case UNION: {
                for (Schema branch : s.getTypes()) {
                    if (branch.getType() == Schema.Type.NULL) continue;
                    this.addArrayColumn(this.p((String)path, branch, "/"), branch, parent);
                }
                break;
            }
            default: {
                throw new TrevniRuntimeException("Unknown schema: " + String.valueOf(s));
            }
        }
        this.seen.remove(s);
    }

    private String p(String parent, Schema child, String sep) {
        if (child.getType() == Schema.Type.UNION) {
            return parent;
        }
        return this.p(parent, child.getFullName(), sep);
    }

    private String p(String parent, String child, String sep) {
        return parent == null ? child : parent + sep + child;
    }

    private ColumnMetaData addColumn(String path, ValueType type, ColumnMetaData parent, boolean isArray) {
        ColumnMetaData column = new ColumnMetaData(path, type);
        if (parent != null) {
            column.setParent(parent);
        }
        column.isArray(isArray);
        this.columns.add(column);
        this.arrayWidths.add(1);
        return column;
    }

    private void addArrayColumn(String path, Schema element, ColumnMetaData parent) {
        if (path == null) {
            path = element.getFullName();
        }
        if (AvroColumnator.isSimple(element)) {
            this.addColumn(path, this.simpleValueType(element), parent, true);
            return;
        }
        int start = this.columns.size();
        ColumnMetaData array = this.addColumn(path, ValueType.NULL, parent, true);
        this.columnize(path, element, array, false);
        this.arrayWidths.set(start, this.columns.size() - start);
    }

    static boolean isSimple(Schema s) {
        switch (s.getType()) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: 
            case STRING: 
            case ENUM: 
            case FIXED: {
                return true;
            }
        }
        return false;
    }

    private ValueType simpleValueType(Schema s) {
        switch (s.getType()) {
            case NULL: {
                return ValueType.NULL;
            }
            case BOOLEAN: {
                return ValueType.BOOLEAN;
            }
            case INT: {
                return ValueType.INT;
            }
            case LONG: {
                return ValueType.LONG;
            }
            case FLOAT: {
                return ValueType.FLOAT;
            }
            case DOUBLE: {
                return ValueType.DOUBLE;
            }
            case BYTES: {
                return ValueType.BYTES;
            }
            case STRING: {
                return ValueType.STRING;
            }
            case ENUM: {
                return ValueType.INT;
            }
            case FIXED: {
                return ValueType.BYTES;
            }
        }
        throw new TrevniRuntimeException("Unknown schema: " + String.valueOf(s));
    }
}

