/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import java.util.Arrays;
import java.util.Random;
import org.apache.cassandra.stress.Stress;
import org.apache.cassandra.stress.generate.Distribution;

public class DistributionQuantized
extends Distribution {
    final Distribution delegate;
    final long[] bounds;
    final Random random = new Random();

    public DistributionQuantized(Distribution delegate, int quantas) {
        this.delegate = delegate;
        this.bounds = new long[quantas + 1];
        this.bounds[0] = delegate.minValue();
        this.bounds[quantas] = delegate.maxValue() + 1L;
        for (int i = 1; i < quantas; ++i) {
            this.bounds[i] = delegate.inverseCumProb((double)i / (double)quantas);
        }
    }

    @Override
    public long next() {
        int quanta = this.quanta(this.delegate.next());
        return this.bounds[quanta] + (long)(this.random.nextDouble() * (double)(this.bounds[quanta + 1] - this.bounds[quanta]));
    }

    @Override
    public double nextDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long inverseCumProb(double cumProb) {
        long val = this.delegate.inverseCumProb(cumProb);
        int quanta = this.quanta(val);
        if (quanta < 0) {
            return this.bounds[0];
        }
        if (quanta >= this.bounds.length - 1) {
            return this.bounds[this.bounds.length - 1] - 1L;
        }
        cumProb -= (double)quanta / ((double)this.bounds.length - 1.0);
        return this.bounds[quanta] + (long)((cumProb *= (double)this.bounds.length - 1.0) * (double)(this.bounds[quanta + 1] - this.bounds[quanta]));
    }

    int quanta(long val) {
        int i = Arrays.binarySearch(this.bounds, val);
        if (i < 0) {
            return -2 - i;
        }
        return i - 1;
    }

    @Override
    public void setSeed(long seed) {
        this.delegate.setSeed(seed);
    }

    public static void main(String[] args) throws Exception {
        Stress.main(new String[]{"print", "dist=qextreme(1..1M,2,2)"});
    }
}

