/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.SelfTestResult;
import com.amazon.corretto.crypto.provider.SelfTestSuite;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

class LibCryptoRng
extends SecureRandom {
    public static final String ALGORITHM_NAME = "LibCryptoRng";
    private static final long serialVersionUID = 1L;
    private static final int MAX_SINGLE_REQUEST = 8192;

    private static native void generate(byte[] var0, int var1, int var2);

    public LibCryptoRng() {
        super(new SPI(), AmazonCorrettoCryptoProvider.INSTANCE);
        Loader.checkNativeLibraryAvailability();
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM_NAME;
    }

    static class SPI
    extends SecureRandomSpi {
        private static final long serialVersionUID = 1L;
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("LibCryptoRng", SPI::runSelfTest);

        static SelfTestResult runSelfTest() {
            LibCryptoRng libCryptoRng = new LibCryptoRng();
            long l = libCryptoRng.nextLong();
            for (int i = 0; i < 3; ++i) {
                if (l == libCryptoRng.nextLong()) continue;
                return SelfTestResult.PASS_RESULT;
            }
            return new SelfTestResult((Throwable)((Object)new AssertionError((Object)"LibCryptoRng's self tests failed.")));
        }

        SPI() {
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            byte[] byArray = new byte[n];
            this.engineNextBytes(byArray);
            return byArray;
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                n = Math.min(8192, byArray.length - i);
                int n2 = i;
                LibCryptoRng.generate(byArray, n2, n);
            }
        }

        @Override
        protected void engineSetSeed(byte[] byArray) {
        }
    }
}

