/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.util.BrowserControl;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.LocalizedStringsHandler;

public class DocumentationAction
extends CayenneAction {
    public static String getActionName() {
        return "Documentation";
    }

    public DocumentationAction(Application application) {
        super(DocumentationAction.getActionName(), application);
    }

    @Override
    public void performAction(ActionEvent e) {
        String url = "https://cayenne.apache.org/docs/";
        String majorVersion = DocumentationAction.getMajorVersion();
        if (!majorVersion.isEmpty()) {
            url = url + majorVersion + "/cayenne-guide/";
        }
        BrowserControl.displayURL(url);
    }

    private static String getMajorVersion() {
        String version = LocalizedStringsHandler.getString("cayenne.version");
        if (version.isEmpty()) {
            return "";
        }
        String majorVersion = version;
        int dash = version.indexOf(45);
        if (dash != -1) {
            majorVersion = version.substring(0, dash);
        }
        String[] components = majorVersion.split("\\.");
        switch (components.length) {
            case 0: {
                return "";
            }
            case 1: {
                return components[0] + ".0";
            }
        }
        return String.join((CharSequence)".", components[0], components[1]);
    }
}

