/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CharsetsTest {
    public static final String AVAIL_CHARSETS = "org.apache.commons.io.CharsetsTest#availableCharsetsKeySet";
    public static final String REQUIRED_CHARSETS = "org.apache.commons.io.CharsetsTest#getRequiredCharsetNames";

    public static Set<String> availableCharsetsKeySet() {
        return Charset.availableCharsets().keySet();
    }

    public static Collection<Charset> availableCharsetsValues() {
        return Charset.availableCharsets().values();
    }

    static Stream<Arguments> charsetAliasProvider() {
        return Charset.availableCharsets().entrySet().stream().flatMap(entry -> ((Charset)entry.getValue()).aliases().stream().map(a -> Arguments.of((Object[])new Object[]{entry.getValue(), a})));
    }

    public static Set<String> getRequiredCharsetNames() {
        return Charsets.requiredCharsets().keySet();
    }

    @ParameterizedTest
    @MethodSource(value={"charsetAliasProvider"})
    void testIsAlias(Charset charset, String charsetAlias) {
        Assertions.assertTrue((boolean)Charsets.isAlias((Charset)charset, (String)charsetAlias));
        Assertions.assertTrue((boolean)Charsets.isAlias((Charset)charset, (String)charsetAlias.toLowerCase()));
        Assertions.assertTrue((boolean)Charsets.isAlias((Charset)charset, (String)charsetAlias.toUpperCase()));
        Assertions.assertTrue((boolean)Charsets.isAlias((Charset)charset, (String)charset.name()));
        Assertions.assertFalse((boolean)Charsets.isAlias((Charset)charset, null));
    }

    @Test
    void testIso8859_1() {
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)Charsets.ISO_8859_1.name());
    }

    @ParameterizedTest
    @MethodSource(value={"availableCharsetsValues"})
    void testIsUTF8Charset(Charset charset) {
        Assumptions.assumeFalse((boolean)StandardCharsets.UTF_8.equals(charset));
        charset.aliases().forEach(n -> Assertions.assertFalse((boolean)Charsets.isUTF8((Charset)Charset.forName(n))));
    }

    void testIsUTF8CharsetUTF8() {
        Assertions.assertTrue((boolean)Charsets.isUTF8((Charset)StandardCharsets.UTF_8));
        StandardCharsets.UTF_8.aliases().forEach(n -> Assertions.assertTrue((boolean)Charsets.isUTF8((Charset)Charset.forName(n))));
    }

    @Test
    void testRequiredCharsets() {
        SortedMap requiredCharsets = Charsets.requiredCharsets();
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("US-ASCII")).name(), (Object)"US-ASCII");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("ISO-8859-1")).name(), (Object)"ISO-8859-1");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-8")).name(), (Object)"UTF-8");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-16")).name(), (Object)"UTF-16");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-16BE")).name(), (Object)"UTF-16BE");
        Assertions.assertEquals((Object)((Charset)requiredCharsets.get("UTF-16LE")).name(), (Object)"UTF-16LE");
    }

    @Test
    void testToCharset_String() {
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((String)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8));
    }

    @Test
    void testToCharsetDefault() {
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharsetDefault((String)null, null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharsetDefault((String)"", null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharsetDefault((String)".", null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharsetDefault(null, (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharsetDefault((String)Charset.defaultCharset().name(), (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharsetDefault((String)StandardCharsets.UTF_8.name(), (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharsetDefault((String)StandardCharsets.UTF_8.name(), null));
    }

    @Test
    void testToCharsetWithStringCharset() {
        Assertions.assertNull((Object)Charsets.toCharset((String)null, null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((String)null, (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)null, (Charset)Charset.defaultCharset()));
        Assertions.assertNull((Object)Charsets.toCharset((Charset)null, null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)Charset.defaultCharset(), (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8, (Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8, null));
    }

    @Test
    void testUsAscii() {
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)Charsets.US_ASCII.name());
    }

    @Test
    void testUtf16() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)Charsets.UTF_16.name());
    }

    @Test
    void testUtf16Be() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16BE.name(), (Object)Charsets.UTF_16BE.name());
    }

    @Test
    void testUtf16Le() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16LE.name(), (Object)Charsets.UTF_16LE.name());
    }

    @Test
    void testUtf8() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)Charsets.UTF_8.name());
    }
}

