/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import org.apache.rat.analysis.HeaderCheckWorker;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.document.DocumentAnalyser;
import org.apache.rat.license.ILicense;
import org.apache.rat.utils.DefaultLog;

class DocumentHeaderAnalyser
implements DocumentAnalyser {
    private final Collection<ILicense> licenses;
    private final IHeaderMatcher generatedMatcher;

    DocumentHeaderAnalyser(IHeaderMatcher generatedMatcher, Collection<ILicense> licenses) {
        this.generatedMatcher = generatedMatcher;
        this.licenses = licenses;
    }

    @Override
    public void analyse(Document document) {
        if (!document.isIgnored()) {
            try (Reader reader = document.reader();){
                DefaultLog.getInstance().debug(String.format("Processing: %s", document));
                HeaderCheckWorker worker = new HeaderCheckWorker(this.generatedMatcher, reader, this.licenses, document);
                worker.read();
            }
            catch (IOException e) {
                DefaultLog.getInstance().warn(String.format("Cannot read header of %s", document));
                document.getMetaData().setDocumentType(Document.Type.UNKNOWN);
            }
            catch (RatHeaderAnalysisException e) {
                DefaultLog.getInstance().warn(String.format("Cannot process header of %s", document));
                document.getMetaData().setDocumentType(Document.Type.UNKNOWN);
            }
        }
    }
}

