/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.jupiter.engine.extension.DefaultRepetitionInfo;

class RepetitionExtension
implements ParameterResolver,
TestWatcher,
ExecutionCondition {
    private final DefaultRepetitionInfo repetitionInfo;

    RepetitionExtension(DefaultRepetitionInfo repetitionInfo) {
        this.repetitionInfo = repetitionInfo;
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == RepetitionInfo.class;
    }

    @Override
    public RepetitionInfo resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.repetitionInfo;
    }

    @Override
    public void testFailed(ExtensionContext context, Throwable cause) {
        this.repetitionInfo.failureCount.incrementAndGet();
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        int failureThreshold = this.repetitionInfo.failureThreshold;
        if (this.repetitionInfo.failureCount.get() >= failureThreshold) {
            return ConditionEvaluationResult.disabled("Failure threshold [" + failureThreshold + "] exceeded");
        }
        return ConditionEvaluationResult.enabled("Failure threshold not exceeded");
    }
}

