/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.CouponList;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectCouponHashSet;
import org.apache.datasketches.hll.DirectHll4Array;
import org.apache.datasketches.hll.DirectHll6Array;
import org.apache.datasketches.hll.DirectHll8Array;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.IntMemorySegmentPairIterator;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

class DirectCouponList
extends AbstractCoupons {
    MemorySegment wseg;
    MemorySegment seg;
    final boolean compact;

    private static int checkSegCompactFlag(MemorySegment wseg, int lgConfigK) {
        assert (!PreambleUtil.extractCompactFlag(wseg)) : "Compact Flag must not be set.";
        return lgConfigK;
    }

    DirectCouponList(int lgConfigK, TgtHllType tgtHllType, CurMode curMode, MemorySegment wseg) {
        super(DirectCouponList.checkSegCompactFlag(wseg, lgConfigK), tgtHllType, curMode);
        this.wseg = wseg;
        this.seg = wseg;
        this.compact = PreambleUtil.extractCompactFlag(wseg);
    }

    DirectCouponList(int lgConfigK, TgtHllType tgtHllType, CurMode curMode, MemorySegment seg, boolean readOnly) {
        super(lgConfigK, tgtHllType, curMode);
        this.wseg = null;
        this.seg = readOnly ? seg.asReadOnly() : seg;
        this.compact = PreambleUtil.extractCompactFlag(seg);
    }

    static DirectCouponList newInstance(int lgConfigK, TgtHllType tgtHllType, MemorySegment dstSeg) {
        PreambleUtil.insertPreInts(dstSeg, 2);
        PreambleUtil.insertSerVer(dstSeg);
        PreambleUtil.insertFamilyId(dstSeg);
        PreambleUtil.insertLgK(dstSeg, lgConfigK);
        PreambleUtil.insertLgArr(dstSeg, 3);
        PreambleUtil.insertFlags(dstSeg, 4);
        PreambleUtil.insertListCount(dstSeg, 0);
        PreambleUtil.insertModes(dstSeg, tgtHllType, CurMode.LIST);
        return new DirectCouponList(lgConfigK, tgtHllType, CurMode.LIST, dstSeg);
    }

    @Override
    CouponList copy() {
        return CouponList.heapifyList(this.seg);
    }

    @Override
    CouponList copyAs(TgtHllType tgtHllType) {
        CouponList clist = CouponList.heapifyList(this.seg);
        return new CouponList(clist, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wseg == null) {
            HllUtil.noWriteAccess();
        }
        int len = 1 << this.getLgCouponArrInts();
        for (int i = 0; i < len; ++i) {
            int couponAtIdx = PreambleUtil.extractInt(this.seg, PreambleUtil.LIST_INT_ARR_START + (i << 2));
            if (couponAtIdx == 0) {
                PreambleUtil.insertInt(this.wseg, PreambleUtil.LIST_INT_ARR_START + (i << 2), coupon);
                int couponCount = PreambleUtil.extractListCount(this.seg);
                PreambleUtil.insertListCount(this.wseg, ++couponCount);
                PreambleUtil.insertEmptyFlag(this.wseg, false);
                if (couponCount >= len) {
                    if (this.lgConfigK < 8) {
                        return DirectCouponList.promoteListOrSetToHll(this);
                    }
                    return DirectCouponList.promoteListToSet(this);
                }
                return this;
            }
            if (couponAtIdx != coupon) continue;
            return this;
        }
        throw new SketchesStateException("Invalid State: no empties & no duplicates");
    }

    @Override
    int getCompactSerializationBytes() {
        return this.getSegDataStart() + (this.getCouponCount() << 2);
    }

    @Override
    int getCouponCount() {
        return PreambleUtil.extractListCount(this.seg);
    }

    @Override
    int[] getCouponIntArr() {
        return null;
    }

    @Override
    int getLgCouponArrInts() {
        int lgArr = PreambleUtil.extractLgArr(this.seg);
        if (lgArr >= 3) {
            return lgArr;
        }
        int coupons = this.getCouponCount();
        return PreambleUtil.computeLgArr(this.seg, coupons, this.lgConfigK);
    }

    @Override
    int getSegDataStart() {
        return PreambleUtil.LIST_INT_ARR_START;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg;
    }

    @Override
    int getPreInts() {
        return 2;
    }

    @Override
    boolean isCompact() {
        return this.compact;
    }

    @Override
    boolean hasMemorySegment() {
        return this.seg.scope().isAlive();
    }

    @Override
    boolean isOffHeap() {
        return this.seg.isNative();
    }

    @Override
    boolean isSameResource(MemorySegment seg) {
        return MemorySegmentStatus.isSameResource(this.seg, seg);
    }

    @Override
    PairIterator iterator() {
        long dataStart = this.getSegDataStart();
        int lenInts = this.compact ? this.getCouponCount() : 1 << this.getLgCouponArrInts();
        return new IntMemorySegmentPairIterator(this.seg, dataStart, lenInts, this.lgConfigK);
    }

    @Override
    void mergeTo(HllSketch that) {
        int lenInts = this.compact ? this.getCouponCount() : 1 << this.getLgCouponArrInts();
        int dataStart = this.getSegDataStart();
        for (int i = 0; i < lenInts; ++i) {
            int pair = this.seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)(dataStart + (i << 2)));
            if (pair == 0) continue;
            that.couponUpdate(pair);
        }
    }

    @Override
    DirectCouponList reset() {
        if (this.wseg == null) {
            throw new SketchesArgumentException("Cannot reset a read-only sketch");
        }
        PreambleUtil.insertEmptyFlag(this.wseg, true);
        int bytes = HllSketch.getMaxUpdatableSerializationBytes(this.lgConfigK, this.tgtHllType);
        Util.clear(this.wseg, 0L, bytes);
        return DirectCouponList.newInstance(this.lgConfigK, this.tgtHllType, this.wseg);
    }

    static final DirectCouponHashSet promoteListToSet(DirectCouponList src) {
        MemorySegment wseg = src.wseg;
        HllUtil.checkPreamble(wseg);
        int lgConfigK = src.lgConfigK;
        TgtHllType tgtHllType = src.tgtHllType;
        int srcOffset = PreambleUtil.LIST_INT_ARR_START;
        int couponArrInts = 1 << src.getLgCouponArrInts();
        int[] couponArr = new int[couponArrInts];
        MemorySegment.copy(wseg, ValueLayout.JAVA_INT_UNALIGNED, srcOffset, couponArr, 0, couponArrInts);
        PreambleUtil.insertPreInts(wseg, 3);
        PreambleUtil.insertLgArr(wseg, 5);
        PreambleUtil.insertCurMin(wseg, 0);
        PreambleUtil.insertCurMode(wseg, CurMode.SET);
        int maxBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        Util.clear(wseg, PreambleUtil.LIST_INT_ARR_START, maxBytes - PreambleUtil.LIST_INT_ARR_START);
        DirectCouponHashSet dchSet = new DirectCouponHashSet(src.lgConfigK, src.tgtHllType, src.wseg);
        for (int i = 0; i < couponArrInts; ++i) {
            int coupon = couponArr[i];
            if (coupon == 0) continue;
            dchSet.couponUpdate(coupon);
        }
        return dchSet;
    }

    static final DirectHllArray promoteListOrSetToHll(DirectCouponList src) {
        MemorySegment wseg = src.wseg;
        HllUtil.checkPreamble(wseg);
        int lgConfigK = src.lgConfigK;
        TgtHllType tgtHllType = src.tgtHllType;
        int srcSegDataStart = src.getSegDataStart();
        double est = src.getEstimate();
        int couponArrInts = 1 << src.getLgCouponArrInts();
        int[] couponArr = new int[couponArrInts];
        MemorySegment.copy(wseg, ValueLayout.JAVA_INT_UNALIGNED, srcSegDataStart, couponArr, 0, couponArrInts);
        PreambleUtil.insertPreInts(wseg, 10);
        PreambleUtil.insertLgArr(wseg, 0);
        PreambleUtil.insertFlags(wseg, 0);
        PreambleUtil.insertCurMin(wseg, 0);
        PreambleUtil.insertCurMode(wseg, CurMode.HLL);
        int maxBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        Util.clear(wseg, PreambleUtil.LIST_INT_ARR_START, maxBytes - PreambleUtil.LIST_INT_ARR_START);
        PreambleUtil.insertNumAtCurMin(wseg, 1 << lgConfigK);
        PreambleUtil.insertKxQ0(wseg, 1 << lgConfigK);
        DirectHllArray dirHllArr = tgtHllType == TgtHllType.HLL_4 ? new DirectHll4Array(lgConfigK, wseg) : (tgtHllType == TgtHllType.HLL_6 ? new DirectHll6Array(lgConfigK, wseg) : new DirectHll8Array(lgConfigK, wseg));
        for (int i = 0; i < couponArrInts; ++i) {
            int coupon = couponArr[i];
            if (coupon == 0) continue;
            dirHllArr.couponUpdate(coupon);
        }
        dirHllArr.putHipAccum(est);
        return dirHllArr;
    }
}

