/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyleClass {
    private static final Logger log = LoggerFactory.getLogger(StyleClass.class);
    private static int MAX_STYLE_CLASSES = 10;
    private final String[] parts;
    private short count = 0;
    private static final char SPACE = ' ';

    public static void setMaxStyleClasses(int max) {
        MAX_STYLE_CLASSES = max;
    }

    public StyleClass() {
        this.parts = new String[MAX_STYLE_CLASSES];
    }

    public StyleClass(Object initial) {
        this();
        this.add(initial);
    }

    public StyleClass(Object initial, boolean immutable) {
        if (immutable) {
            this.parts = new String[]{initial.toString()};
            this.count = 1;
        } else {
            this.parts = new String[12];
            this.add(initial);
        }
    }

    public boolean isEmpty() {
        return this.prepareBuild() <= 0;
    }

    public boolean isNotEmpty() {
        return this.prepareBuild() > 0;
    }

    public StyleClass add(String styleClass) {
        if (styleClass == null || styleClass.length() == 0) {
            return this;
        }
        if (styleClass.charAt(0) == ' ') {
            styleClass = styleClass.trim();
        }
        if (styleClass.indexOf(32) > 0) {
            int i = 0;
            int n = 0;
            while ((n = styleClass.indexOf(32, i)) > 0) {
                this.add(styleClass.substring(i, n));
                i = n + 1;
            }
            if (i < styleClass.length()) {
                this.add(styleClass.substring(i));
            }
            return this;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.parts[i].equals(styleClass)) continue;
            return this;
        }
        if (this.count == this.parts.length) {
            if (this.parts.length == 1) {
                throw new NotSupportedException((Object)this, "add");
            }
            throw new InvalidOperationException("Too many style classes: " + this.build());
        }
        short s = this.count;
        this.count = (short)(s + 1);
        this.parts[s] = styleClass;
        return this;
    }

    public StyleClass add(String ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            this.add(parts[i]);
        }
        return this;
    }

    public StyleClass add(Object styleClass) {
        if (styleClass == null) {
            return this;
        }
        return this.add(styleClass.toString());
    }

    public StyleClass add(boolean condition, Object styleClass) {
        if (condition) {
            return this.add(styleClass);
        }
        return this;
    }

    public StyleClass remove(String styleClass) {
        if (styleClass == null || styleClass.length() == 0) {
            return this;
        }
        if (styleClass.indexOf(32) >= 0) {
            throw new InvalidArgumentException("styleClass", (Object)styleClass);
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.parts[i].equals(styleClass)) continue;
            this.remove(i);
            break;
        }
        return this;
    }

    public String build() {
        int length = this.prepareBuild();
        if (length <= 0) {
            return "";
        }
        if (this.count == 1) {
            return this.parts[0];
        }
        StringBuilder b = new StringBuilder(length);
        for (int i = 0; i < this.count; ++i) {
            String s = this.parts[i];
            if (s.charAt(0) == '-') continue;
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(this.parts[i]);
        }
        if (b.length() != length) {
            log.warn("Length estimate ({}) was wrong: {}", (Object)length, (Object)b.length());
        }
        return b.toString();
    }

    public String toString() {
        return this.build();
    }

    private boolean contains(String[] list, short count, String s) {
        for (int i = 0; i < count; ++i) {
            if (!list[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    private int prepareBuild() {
        String[] remove = null;
        short removeCount = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.parts[i].charAt(0) != '-') continue;
            if (remove == null) {
                remove = new String[4];
            }
            short s = removeCount;
            removeCount = (short)(removeCount + 1);
            remove[s] = this.parts[i].substring(1);
        }
        int length = -1;
        for (int i = 0; i < this.count; ++i) {
            String s = this.parts[i];
            if (s.charAt(0) == '-') continue;
            if (this.contains(remove, removeCount, s)) {
                this.remove(i--);
                continue;
            }
            length += s.length() + 1;
        }
        return length > 0 ? length : 0;
    }

    private void remove(int index) {
        if (index < 0 || index >= this.count) {
            return;
        }
        this.count = (short)(this.count - 1);
        while (index < this.count) {
            this.parts[index] = this.parts[index + 1];
            ++index;
        }
        this.parts[this.count] = null;
    }

    public static final boolean existsIn(String styleClasses, String styleClassName) {
        return StyleClass.find(styleClasses, styleClassName, 0) >= 0;
    }

    public static final String addTo(String styleClasses, String styleClassName) {
        if (styleClasses == null || styleClasses.length() == 0) {
            return styleClassName;
        }
        if (StyleClass.existsIn(styleClasses, styleClassName)) {
            return styleClasses;
        }
        return StringUtils.concat((String[])new String[]{styleClasses, " ", styleClassName});
    }

    public static final String removeFrom(String styleClasses, String styleClassName) {
        if (styleClassName == null) {
            return styleClasses;
        }
        int idx = StyleClass.find(styleClasses, styleClassName, 0);
        if (idx < 0) {
            return styleClasses;
        }
        if (idx <= 1) {
            if (styleClasses.length() > (idx += styleClassName.length()) && styleClasses.charAt(idx) == ' ') {
                ++idx;
            }
            return styleClasses.substring(idx);
        }
        if (idx + styleClassName.length() == styleClasses.length()) {
            return styleClasses.substring(0, idx - 1);
        }
        int after = idx + styleClassName.length();
        int before = idx - 1;
        return StringUtils.concat((String[])new String[]{styleClasses.substring(0, before), styleClasses.substring(after)});
    }

    public static final String addOrRemove(String styleClasses, String styleClassName, boolean add) {
        if (add) {
            return StyleClass.addTo(styleClasses, styleClassName);
        }
        return StyleClass.removeFrom(styleClasses, styleClassName);
    }

    private static final int find(String styleClasses, String styleClassName, int fromIdx) {
        if (styleClasses == null) {
            return -1;
        }
        int idx = styleClasses.indexOf(styleClassName, fromIdx);
        if (idx < 0) {
            return -1;
        }
        if (idx > 0 && styleClasses.charAt(idx - 1) != ' ') {
            return StyleClass.find(styleClasses, styleClassName, idx + 1);
        }
        int end = idx + styleClassName.length();
        if (end < styleClasses.length() && styleClasses.charAt(end) != ' ') {
            return StyleClass.find(styleClasses, styleClassName, idx + 1);
        }
        return idx;
    }
}

