/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public final class NativeS3FileSystem
extends FileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(NativeS3FileSystem.class);
    private static final String UNSUPPORTED = "The s3n:// client to Amazon S3 is no longer available: please migrate to the s3a:// client";

    @Override
    public String getScheme() {
        return "s3n";
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        throw new IOException(UNSUPPORTED);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public URI getUri() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }
}

