/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.util.functions.StreamingFunctionUtils;

public abstract class TableAbstractCoUdfStreamOperator<OUT, LEFT_FUNC extends Function, RIGHT_FUNC extends Function>
extends AbstractStreamOperator<OUT>
implements OutputTypeConfigurable<OUT> {
    private static final long serialVersionUID = 1L;
    protected final LEFT_FUNC leftTriggeredUserFunction;
    protected final RIGHT_FUNC rightTriggeredUserFunction;

    public TableAbstractCoUdfStreamOperator(LEFT_FUNC leftTriggeredUserFunction, RIGHT_FUNC rightTriggeredUserFunction) {
        this.leftTriggeredUserFunction = (Function)Objects.requireNonNull(leftTriggeredUserFunction);
        this.rightTriggeredUserFunction = (Function)Objects.requireNonNull(rightTriggeredUserFunction);
        this.checkUdfCheckpointingPreconditions();
    }

    public LEFT_FUNC getLeftTriggeredUserFunction() {
        return this.leftTriggeredUserFunction;
    }

    public RIGHT_FUNC getRightTriggeredUserFunction() {
        return this.rightTriggeredUserFunction;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        super.setup(containingTask, config, output);
        FunctionUtils.setFunctionRuntimeContext(this.leftTriggeredUserFunction, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.setFunctionRuntimeContext(this.rightTriggeredUserFunction, (RuntimeContext)this.getRuntimeContext());
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        StreamingFunctionUtils.snapshotFunctionState((StateSnapshotContext)context, (OperatorStateBackend)this.getOperatorStateBackend(), this.leftTriggeredUserFunction);
        StreamingFunctionUtils.snapshotFunctionState((StateSnapshotContext)context, (OperatorStateBackend)this.getOperatorStateBackend(), this.rightTriggeredUserFunction);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        StreamingFunctionUtils.restoreFunctionState((StateInitializationContext)context, this.leftTriggeredUserFunction);
        StreamingFunctionUtils.restoreFunctionState((StateInitializationContext)context, this.rightTriggeredUserFunction);
    }

    public void open() throws Exception {
        super.open();
        super.open();
        FunctionUtils.openFunction(this.leftTriggeredUserFunction, (OpenContext)DefaultOpenContext.INSTANCE);
        FunctionUtils.openFunction(this.rightTriggeredUserFunction, (OpenContext)DefaultOpenContext.INSTANCE);
    }

    public void finish() throws Exception {
        super.finish();
        if (this.leftTriggeredUserFunction instanceof SinkFunction) {
            ((SinkFunction)this.leftTriggeredUserFunction).finish();
        }
        if (this.rightTriggeredUserFunction instanceof SinkFunction) {
            ((SinkFunction)this.rightTriggeredUserFunction).finish();
        }
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.leftTriggeredUserFunction);
        FunctionUtils.closeFunction(this.rightTriggeredUserFunction);
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        if (this.leftTriggeredUserFunction instanceof CheckpointListener) {
            ((CheckpointListener)this.leftTriggeredUserFunction).notifyCheckpointComplete(checkpointId);
        }
        if (this.rightTriggeredUserFunction instanceof CheckpointListener) {
            ((CheckpointListener)this.rightTriggeredUserFunction).notifyCheckpointComplete(checkpointId);
        }
    }

    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        super.notifyCheckpointAborted(checkpointId);
        if (this.leftTriggeredUserFunction instanceof CheckpointListener) {
            ((CheckpointListener)this.leftTriggeredUserFunction).notifyCheckpointAborted(checkpointId);
        }
        if (this.rightTriggeredUserFunction instanceof CheckpointListener) {
            ((CheckpointListener)this.rightTriggeredUserFunction).notifyCheckpointAborted(checkpointId);
        }
    }

    public void setOutputType(TypeInformation<OUT> outTypeInfo, ExecutionConfig executionConfig) {
        StreamingFunctionUtils.setOutputType(this.leftTriggeredUserFunction, outTypeInfo, (ExecutionConfig)executionConfig);
        StreamingFunctionUtils.setOutputType(this.rightTriggeredUserFunction, outTypeInfo, (ExecutionConfig)executionConfig);
    }

    private void checkUdfCheckpointingPreconditions() {
        if (this.leftTriggeredUserFunction instanceof CheckpointedFunction && this.leftTriggeredUserFunction instanceof ListCheckpointed) {
            throw new IllegalStateException("Triggered user functions are not allowed to implement CheckpointedFunction AND ListCheckpointed.");
        }
        if (this.rightTriggeredUserFunction instanceof CheckpointedFunction && this.rightTriggeredUserFunction instanceof ListCheckpointed) {
            throw new IllegalStateException("Triggered user functions are not allowed to implement CheckpointedFunction AND ListCheckpointed.");
        }
    }
}

