/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.operations.FunctionQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;

@Internal
final class FunctionTableFactory {
    FunctionTableFactory() {
    }

    QueryOperation create(ResolvedExpression resolvedCall) {
        if (!ApiExpressionUtils.isFunctionOfKind(resolvedCall, FunctionKind.PROCESS_TABLE)) {
            throw new ValidationException("Invalid expression. The expression must be a call to a process table function.");
        }
        CallExpression call = (CallExpression)resolvedCall;
        ContextResolvedFunction contextFunction = ContextResolvedFunction.fromCallExpression(call);
        DataType dataType = call.getOutputDataType();
        return new FunctionQueryOperation(contextFunction, call.getResolvedChildren(), ResolvedSchema.physical(DataType.getFieldNames(dataType), DataType.getFieldDataTypes(dataType)));
    }
}

