/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class RawToStringCastRule
extends AbstractNullAwareCodeGeneratorCastRule<Object, String> {
    static final RawToStringCastRule INSTANCE = new RawToStringCastRule();

    private RawToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.RAW).target(LogicalTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        CodeGeneratorContext codeGeneratorContext = context.getCodeGeneratorContext();
        String typeSerializer = context.declareTypeSerializer(inputLogicalType);
        String deserializedObjTerm = CodeGenUtils.newName(codeGeneratorContext, "deserializedObj");
        String resultStringTerm = CodeGenUtils.newName(codeGeneratorContext, "resultString");
        int length = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        return new CastRuleUtils.CodeWriter().declStmt(Object.class, deserializedObjTerm, CastRuleUtils.methodCall(inputTerm, "toObject", typeSerializer)).ifStmt(deserializedObjTerm + " != null", thenWriter -> CharVarCharTrimPadCastRule.padAndTrimStringIfNeeded(thenWriter, targetLogicalType, context.legacyBehaviour(), length, resultStringTerm, CastRuleUtils.methodCall(deserializedObjTerm, "toString", new Object[0]), context.getCodeGeneratorContext()).assignStmt(returnVariable, CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), resultStringTerm)), elseWriter -> elseWriter.assignStmt(returnVariable, "null")).toString();
    }
}

