/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.temporal.TemporalProcessTimeJoinOperator;
import org.apache.flink.table.runtime.operators.join.temporal.TemporalRowTimeJoinOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-temporal-join", version=1, producedTransformations={"temporal-join"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecTemporalJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String TEMPORAL_JOIN_TRANSFORMATION = "temporal-join";
    public static final String FIELD_NAME_JOIN_SPEC = "joinSpec";
    public static final String FIELD_NAME_IS_TEMPORAL_FUNCTION_JOIN = "isTemporalFunctionJoin";
    public static final String FIELD_NAME_LEFT_TIME_ATTRIBUTE_INDEX = "leftTimeAttributeIndex";
    public static final String FIELD_NAME_RIGHT_TIME_ATTRIBUTE_INDEX = "rightTimeAttributeIndex";
    public static final int FIELD_INDEX_FOR_PROC_TIME_ATTRIBUTE = -1;
    @JsonProperty(value="joinSpec")
    private final JoinSpec joinSpec;
    @JsonProperty(value="isTemporalFunctionJoin")
    private final boolean isTemporalFunctionJoin;
    @JsonProperty(value="leftTimeAttributeIndex")
    private final int leftTimeAttributeIndex;
    @JsonProperty(value="rightTimeAttributeIndex")
    private final int rightTimeAttributeIndex;

    public StreamExecTemporalJoin(ReadableConfig tableConfig, JoinSpec joinSpec, boolean isTemporalTableFunctionJoin, int leftTimeAttributeIndex, int rightTimeAttributeIndex, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecTemporalJoin.class), ExecNodeContext.newPersistedConfig(StreamExecTemporalJoin.class, tableConfig), joinSpec, isTemporalTableFunctionJoin, leftTimeAttributeIndex, rightTimeAttributeIndex, Arrays.asList(leftInputProperty, rightInputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecTemporalJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinSpec") JoinSpec joinSpec, @JsonProperty(value="isTemporalFunctionJoin") boolean isTemporalTableFunctionJoin, @JsonProperty(value="leftTimeAttributeIndex") int leftTimeAttributeIndex, @JsonProperty(value="rightTimeAttributeIndex") int rightTimeAttributeIndex, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((rightTimeAttributeIndex == -1 || rightTimeAttributeIndex >= 0 ? 1 : 0) != 0);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.isTemporalFunctionJoin = isTemporalTableFunctionJoin;
        this.leftTimeAttributeIndex = leftTimeAttributeIndex;
        this.rightTimeAttributeIndex = rightTimeAttributeIndex;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftInputType = (RowType)leftInputEdge.getOutputType();
        RowType rightInputType = (RowType)rightInputEdge.getOutputType();
        JoinUtil.validateJoinSpec(this.joinSpec, leftInputType, rightInputType, true);
        FlinkJoinType joinType = this.joinSpec.getJoinType();
        if (this.isTemporalFunctionJoin) {
            if (joinType != FlinkJoinType.INNER) {
                throw new ValidationException("Temporal table function join currently only support INNER JOIN, but was " + String.valueOf(joinType) + " JOIN.");
            }
        } else if (joinType != FlinkJoinType.LEFT && joinType != FlinkJoinType.INNER) {
            throw new TableException("Temporal table join currently only support INNER JOIN and LEFT JOIN, but was " + String.valueOf(joinType) + " JOIN.");
        }
        RowType returnType = (RowType)this.getOutputType();
        TwoInputStreamOperator<RowData, RowData, RowData> joinOperator = this.getJoinOperator(config, planner.getFlinkContext().getClassLoader(), leftInputType, rightInputType);
        Transformation<?> leftTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightTransform = rightInputEdge.translateToPlan(planner);
        TwoInputTransformation<RowData, RowData, RowData> ret = ExecNodeUtil.createTwoInputTransformation(leftTransform, rightTransform, this.createTransformationMeta(TEMPORAL_JOIN_TRANSFORMATION, config), joinOperator, InternalTypeInfo.of((RowType)returnType), leftTransform.getParallelism(), false);
        RowDataKeySelector leftKeySelector = this.getLeftKeySelector(planner.getFlinkContext().getClassLoader(), leftInputType);
        RowDataKeySelector rightKeySelector = this.getRightKeySelector(planner.getFlinkContext().getClassLoader(), rightInputType);
        ret.setStateKeySelectors((KeySelector)leftKeySelector, (KeySelector)rightKeySelector);
        ret.setStateKeyType((TypeInformation)leftKeySelector.getProducedType());
        return ret;
    }

    private RowDataKeySelector getLeftKeySelector(ClassLoader classLoader, RowType leftInputType) {
        return KeySelectorUtil.getRowDataSelector(classLoader, this.joinSpec.getLeftKeys(), (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)leftInputType));
    }

    private RowDataKeySelector getRightKeySelector(ClassLoader classLoader, RowType rightInputType) {
        return KeySelectorUtil.getRowDataSelector(classLoader, this.joinSpec.getRightKeys(), (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)rightInputType));
    }

    private TwoInputStreamOperator<RowData, RowData, RowData> getJoinOperator(ExecNodeConfig config, ClassLoader classLoader, RowType leftInputType, RowType rightInputType) {
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, classLoader);
        ExprCodeGenerator exprGenerator = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)leftInputType, CodeGenUtils.DEFAULT_INPUT1_TERM(), JavaScalaConversionUtil.toScala(Optional.empty())).bindSecondInput((LogicalType)rightInputType, CodeGenUtils.DEFAULT_INPUT2_TERM(), JavaScalaConversionUtil.toScala(Optional.empty()));
        String body = "return true;";
        if (this.joinSpec.getNonEquiCondition().isPresent()) {
            GeneratedExpression condition = exprGenerator.generateExpression(this.joinSpec.getNonEquiCondition().get());
            body = String.format("%s\nreturn %s;", condition.code(), condition.resultTerm());
        }
        GeneratedJoinCondition generatedJoinCondition = FunctionCodeGenerator.generateJoinCondition(ctx, "ConditionFunction", body, CodeGenUtils.DEFAULT_INPUT1_TERM(), CodeGenUtils.DEFAULT_INPUT2_TERM());
        return this.createJoinOperator(config, leftInputType, rightInputType, generatedJoinCondition);
    }

    private TwoInputStreamOperator<RowData, RowData, RowData> createJoinOperator(ExecNodeConfig config, RowType leftInputType, RowType rightInputType, GeneratedJoinCondition generatedJoinCondition) {
        boolean isLeftOuterJoin = this.joinSpec.getJoinType() == FlinkJoinType.LEFT;
        long minRetentionTime = config.getStateRetentionTime();
        long maxRetentionTime = TableConfigUtils.getMaxIdleStateRetentionTime(config);
        if (this.rightTimeAttributeIndex >= 0) {
            return new TemporalRowTimeJoinOperator(InternalTypeInfo.of((RowType)leftInputType), InternalTypeInfo.of((RowType)rightInputType), generatedJoinCondition, this.leftTimeAttributeIndex, this.rightTimeAttributeIndex, minRetentionTime, maxRetentionTime, isLeftOuterJoin);
        }
        if (this.isTemporalFunctionJoin) {
            return new TemporalProcessTimeJoinOperator(InternalTypeInfo.of((RowType)rightInputType), generatedJoinCondition, minRetentionTime, maxRetentionTime, isLeftOuterJoin);
        }
        throw new TableException("Processing-time temporal join is not supported yet.");
    }
}

