/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.planner.plan.schema.RawRelDataType;
import org.apache.flink.table.planner.plan.schema.StructuredRelDataType;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DescriptorType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

@Internal
public final class LogicalRelDataTypeConverter {
    public static RelDataType toRelDataType(LogicalType logicalType, RelDataTypeFactory relDataTypeFactory) {
        LogicalToRelDataTypeConverter converter = new LogicalToRelDataTypeConverter(relDataTypeFactory);
        RelDataType relDataType = (RelDataType)logicalType.accept((LogicalTypeVisitor)converter);
        return relDataTypeFactory.createTypeWithNullability(relDataType, logicalType.isNullable());
    }

    public static LogicalType toLogicalType(RelDataType relDataType, DataTypeFactory dataTypeFactory) {
        LogicalType logicalType = LogicalRelDataTypeConverter.toLogicalTypeNotNull(relDataType, dataTypeFactory);
        return logicalType.copy(relDataType.isNullable());
    }

    private static LogicalType toLogicalTypeNotNull(RelDataType relDataType, DataTypeFactory dataTypeFactory) {
        switch (relDataType.getSqlTypeName()) {
            case BOOLEAN: {
                return new BooleanType(false);
            }
            case TINYINT: {
                return new TinyIntType(false);
            }
            case SMALLINT: {
                return new SmallIntType(false);
            }
            case INTEGER: {
                return new IntType(false);
            }
            case BIGINT: {
                return new BigIntType(false);
            }
            case DECIMAL: {
                if (relDataType.getScale() < 0) {
                    return new DecimalType(false, relDataType.getPrecision() - relDataType.getScale(), 0);
                }
                return new DecimalType(false, relDataType.getPrecision(), relDataType.getScale());
            }
            case FLOAT: {
                return new FloatType(false);
            }
            case DOUBLE: {
                return new DoubleType(false);
            }
            case DATE: {
                return new DateType(false);
            }
            case TIME: {
                return new TimeType(false, relDataType.getPrecision());
            }
            case TIMESTAMP: {
                return new TimestampType(false, LogicalRelDataTypeConverter.getTimestampKind(relDataType), relDataType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new LocalZonedTimestampType(false, LogicalRelDataTypeConverter.getTimestampKind(relDataType), relDataType.getPrecision());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return new YearMonthIntervalType(false, LogicalRelDataTypeConverter.getYearMonthResolution(relDataType), relDataType.getPrecision());
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: {
                return new DayTimeIntervalType(false, LogicalRelDataTypeConverter.getDayTimeResolution(relDataType), relDataType.getPrecision(), relDataType.getScale());
            }
            case INTERVAL_SECOND: {
                return new DayTimeIntervalType(false, LogicalRelDataTypeConverter.getDayTimeResolution(relDataType), 2, relDataType.getScale());
            }
            case CHAR: {
                if (relDataType.getPrecision() == 0) {
                    return CharType.ofEmptyLiteral();
                }
                return new CharType(false, relDataType.getPrecision());
            }
            case VARCHAR: {
                if (relDataType.getPrecision() == 0) {
                    return VarCharType.ofEmptyLiteral();
                }
                return new VarCharType(false, relDataType.getPrecision());
            }
            case BINARY: {
                if (relDataType.getPrecision() == 0) {
                    return BinaryType.ofEmptyLiteral();
                }
                return new BinaryType(false, relDataType.getPrecision());
            }
            case VARBINARY: {
                if (relDataType.getPrecision() == 0) {
                    return VarBinaryType.ofEmptyLiteral();
                }
                return new VarBinaryType(false, relDataType.getPrecision());
            }
            case NULL: {
                return new NullType();
            }
            case SYMBOL: {
                return new SymbolType(false);
            }
            case MULTISET: {
                return new MultisetType(false, LogicalRelDataTypeConverter.toLogicalType(relDataType.getComponentType(), dataTypeFactory));
            }
            case ARRAY: {
                return new ArrayType(false, LogicalRelDataTypeConverter.toLogicalType(relDataType.getComponentType(), dataTypeFactory));
            }
            case MAP: {
                return new MapType(false, LogicalRelDataTypeConverter.toLogicalType(relDataType.getKeyType(), dataTypeFactory), LogicalRelDataTypeConverter.toLogicalType(relDataType.getValueType(), dataTypeFactory));
            }
            case DISTINCT: {
                throw new TableException("DISTINCT type is currently not supported.");
            }
            case ROW: {
                return new RowType(false, relDataType.getFieldList().stream().map(f -> new RowType.RowField(f.getName(), LogicalRelDataTypeConverter.toLogicalType(f.getType(), dataTypeFactory))).collect(Collectors.toList()));
            }
            case COLUMN_LIST: {
                return new DescriptorType(false);
            }
            case STRUCTURED: 
            case OTHER: {
                if (relDataType instanceof StructuredRelDataType) {
                    return ((StructuredRelDataType)relDataType).getStructuredType();
                }
                if (!(relDataType instanceof RawRelDataType)) break;
                return ((RawRelDataType)relDataType).getRawType();
            }
        }
        throw new TableException("Unsupported RelDataType: " + String.valueOf(relDataType));
    }

    private static TimestampKind getTimestampKind(RelDataType relDataType) {
        if (relDataType instanceof TimeIndicatorRelDataType) {
            TimeIndicatorRelDataType timeIndicator = (TimeIndicatorRelDataType)relDataType;
            if (timeIndicator.isEventTime()) {
                return TimestampKind.ROWTIME;
            }
            return TimestampKind.PROCTIME;
        }
        return TimestampKind.REGULAR;
    }

    private static YearMonthIntervalType.YearMonthResolution getYearMonthResolution(RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case INTERVAL_YEAR: {
                return YearMonthIntervalType.YearMonthResolution.YEAR;
            }
            case INTERVAL_YEAR_MONTH: {
                return YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH;
            }
            case INTERVAL_MONTH: {
                return YearMonthIntervalType.YearMonthResolution.MONTH;
            }
        }
        throw new TableException("Unsupported YearMonthResolution.");
    }

    private static DayTimeIntervalType.DayTimeResolution getDayTimeResolution(RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case INTERVAL_DAY: {
                return DayTimeIntervalType.DayTimeResolution.DAY;
            }
            case INTERVAL_DAY_HOUR: {
                return DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR;
            }
            case INTERVAL_DAY_MINUTE: {
                return DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE;
            }
            case INTERVAL_DAY_SECOND: {
                return DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND;
            }
            case INTERVAL_HOUR: {
                return DayTimeIntervalType.DayTimeResolution.HOUR;
            }
            case INTERVAL_HOUR_MINUTE: {
                return DayTimeIntervalType.DayTimeResolution.HOUR_TO_MINUTE;
            }
            case INTERVAL_HOUR_SECOND: {
                return DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND;
            }
            case INTERVAL_MINUTE: {
                return DayTimeIntervalType.DayTimeResolution.MINUTE;
            }
            case INTERVAL_MINUTE_SECOND: {
                return DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND;
            }
            case INTERVAL_SECOND: {
                return DayTimeIntervalType.DayTimeResolution.SECOND;
            }
        }
        throw new TableException("Unsupported DayTimeResolution.");
    }

    private static class LogicalToRelDataTypeConverter
    implements LogicalTypeVisitor<RelDataType> {
        private final RelDataTypeFactory relDataTypeFactory;

        LogicalToRelDataTypeConverter(RelDataTypeFactory relDataTypeFactory) {
            this.relDataTypeFactory = relDataTypeFactory;
        }

        public RelDataType visit(CharType charType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.CHAR, charType.getLength());
        }

        public RelDataType visit(VarCharType varCharType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.VARCHAR, varCharType.getLength());
        }

        public RelDataType visit(BooleanType booleanType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        public RelDataType visit(BinaryType binaryType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.BINARY, binaryType.getLength());
        }

        public RelDataType visit(VarBinaryType varBinaryType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.VARBINARY, varBinaryType.getLength());
        }

        public RelDataType visit(DecimalType decimalType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.DECIMAL, decimalType.getPrecision(), decimalType.getScale());
        }

        public RelDataType visit(TinyIntType tinyIntType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.TINYINT);
        }

        public RelDataType visit(SmallIntType smallIntType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.SMALLINT);
        }

        public RelDataType visit(IntType intType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        public RelDataType visit(BigIntType bigIntType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.BIGINT);
        }

        public RelDataType visit(FloatType floatType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.FLOAT);
        }

        public RelDataType visit(DoubleType doubleType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.DOUBLE);
        }

        public RelDataType visit(DateType dateType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.DATE);
        }

        public RelDataType visit(TimeType timeType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.TIME, timeType.getPrecision());
        }

        public RelDataType visit(TimestampType timestampType) {
            RelDataType timestampRelDataType = this.relDataTypeFactory.createSqlType(SqlTypeName.TIMESTAMP, timestampType.getPrecision());
            switch (timestampType.getKind()) {
                case REGULAR: {
                    return timestampRelDataType;
                }
                case ROWTIME: {
                    assert (timestampType.getPrecision() == 3);
                    return new TimeIndicatorRelDataType(this.relDataTypeFactory.getTypeSystem(), (BasicSqlType)timestampRelDataType, timestampType.isNullable(), true);
                }
            }
            throw new TableException("Unknown timestamp kind.");
        }

        public RelDataType visit(ZonedTimestampType zonedTimestampType) {
            throw new TableException("TIMESTAMP WITH TIME ZONE is currently not supported.");
        }

        public RelDataType visit(LocalZonedTimestampType localZonedTimestampType) {
            RelDataType timestampRelDataType = this.relDataTypeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, localZonedTimestampType.getPrecision());
            switch (localZonedTimestampType.getKind()) {
                case REGULAR: {
                    return timestampRelDataType;
                }
                case ROWTIME: {
                    assert (localZonedTimestampType.getPrecision() == 3);
                    return new TimeIndicatorRelDataType(this.relDataTypeFactory.getTypeSystem(), (BasicSqlType)timestampRelDataType, localZonedTimestampType.isNullable(), true);
                }
                case PROCTIME: {
                    assert (localZonedTimestampType.getPrecision() == 3);
                    return new TimeIndicatorRelDataType(this.relDataTypeFactory.getTypeSystem(), (BasicSqlType)timestampRelDataType, localZonedTimestampType.isNullable(), false);
                }
            }
            throw new TableException("Unknown timestamp kind.");
        }

        public RelDataType visit(YearMonthIntervalType yearMonthIntervalType) {
            SqlIntervalQualifier intervalQualifier;
            int yearPrecision = yearMonthIntervalType.getYearPrecision();
            switch (yearMonthIntervalType.getResolution()) {
                case YEAR: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.YEAR, yearPrecision, TimeUnit.YEAR, -1, SqlParserPos.ZERO);
                    break;
                }
                case YEAR_TO_MONTH: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.YEAR, yearPrecision, TimeUnit.MONTH, -1, SqlParserPos.ZERO);
                    break;
                }
                case MONTH: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.MONTH, -1, TimeUnit.MONTH, -1, SqlParserPos.ZERO);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown interval resolution.");
                }
            }
            return this.relDataTypeFactory.createSqlIntervalType(intervalQualifier);
        }

        public RelDataType visit(DayTimeIntervalType dayTimeIntervalType) {
            SqlIntervalQualifier intervalQualifier;
            int dayPrecision = dayTimeIntervalType.getDayPrecision();
            int fractionalPrecision = dayTimeIntervalType.getFractionalPrecision();
            switch (dayTimeIntervalType.getResolution()) {
                case DAY: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, dayPrecision, TimeUnit.DAY, -1, SqlParserPos.ZERO);
                    break;
                }
                case DAY_TO_HOUR: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, dayPrecision, TimeUnit.HOUR, -1, SqlParserPos.ZERO);
                    break;
                }
                case DAY_TO_MINUTE: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, dayPrecision, TimeUnit.MINUTE, -1, SqlParserPos.ZERO);
                    break;
                }
                case DAY_TO_SECOND: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, dayPrecision, TimeUnit.SECOND, fractionalPrecision, SqlParserPos.ZERO);
                    break;
                }
                case HOUR: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.HOUR, -1, TimeUnit.HOUR, -1, SqlParserPos.ZERO);
                    break;
                }
                case HOUR_TO_MINUTE: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.HOUR, -1, TimeUnit.MINUTE, -1, SqlParserPos.ZERO);
                    break;
                }
                case HOUR_TO_SECOND: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.HOUR, -1, TimeUnit.SECOND, fractionalPrecision, SqlParserPos.ZERO);
                    break;
                }
                case MINUTE: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.MINUTE, -1, TimeUnit.MINUTE, -1, SqlParserPos.ZERO);
                    break;
                }
                case MINUTE_TO_SECOND: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.MINUTE, -1, TimeUnit.SECOND, fractionalPrecision, SqlParserPos.ZERO);
                    break;
                }
                case SECOND: {
                    intervalQualifier = new SqlIntervalQualifier(TimeUnit.SECOND, -1, TimeUnit.SECOND, fractionalPrecision, SqlParserPos.ZERO);
                    break;
                }
                default: {
                    throw new TableException("Unknown interval resolution.");
                }
            }
            return this.relDataTypeFactory.createSqlIntervalType(intervalQualifier);
        }

        public RelDataType visit(ArrayType arrayType) {
            RelDataType elementRelDataType = LogicalRelDataTypeConverter.toRelDataType(arrayType.getElementType(), this.relDataTypeFactory);
            return this.relDataTypeFactory.createArrayType(elementRelDataType, -1L);
        }

        public RelDataType visit(MultisetType multisetType) {
            RelDataType elementRelDataType = LogicalRelDataTypeConverter.toRelDataType(multisetType.getElementType(), this.relDataTypeFactory);
            return this.relDataTypeFactory.createMultisetType(elementRelDataType, -1L);
        }

        public RelDataType visit(MapType mapType) {
            RelDataType keyRelDataType = LogicalRelDataTypeConverter.toRelDataType(mapType.getKeyType(), this.relDataTypeFactory);
            RelDataType valueRelDataType = LogicalRelDataTypeConverter.toRelDataType(mapType.getValueType(), this.relDataTypeFactory);
            return this.relDataTypeFactory.createMapType(keyRelDataType, valueRelDataType);
        }

        public RelDataType visit(RowType rowType) {
            return this.relDataTypeFactory.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, rowType.getFields().stream().map(f -> LogicalRelDataTypeConverter.toRelDataType(f.getType(), this.relDataTypeFactory)).collect(Collectors.toList()), rowType.getFieldNames());
        }

        public RelDataType visit(DistinctType distinctType) {
            throw new TableException("DISTINCT type is currently not supported.");
        }

        public RelDataType visit(StructuredType structuredType) {
            ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
            for (int i = 0; i < structuredType.getAttributes().size(); ++i) {
                StructuredType.StructuredAttribute attribute = (StructuredType.StructuredAttribute)structuredType.getAttributes().get(i);
                RelDataTypeFieldImpl field = new RelDataTypeFieldImpl(attribute.getName(), i, LogicalRelDataTypeConverter.toRelDataType(attribute.getType(), this.relDataTypeFactory));
                fields.add(field);
            }
            return new StructuredRelDataType(structuredType, fields);
        }

        public RelDataType visit(NullType nullType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.NULL);
        }

        public RelDataType visit(RawType<?> rawType) {
            return new RawRelDataType(rawType);
        }

        public RelDataType visit(SymbolType<?> symbolType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.SYMBOL);
        }

        public RelDataType visit(DescriptorType descriptorType) {
            return this.relDataTypeFactory.createSqlType(SqlTypeName.COLUMN_LIST);
        }

        public RelDataType visit(LogicalType other) {
            throw new TableException(String.format("Logical type '%s' cannot be converted to a RelDataType.", other));
        }
    }
}

