/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.CheckpointingMode;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.SavepointWriterOperatorFactory;
import org.apache.flink.state.api.output.BootstrapStreamTaskRunner;
import org.apache.flink.state.api.output.OperatorSubtaskStateReducer;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.state.api.output.operators.BroadcastStateBootstrapOperator;
import org.apache.flink.state.api.output.operators.GroupReduceOperator;
import org.apache.flink.state.api.runtime.MutableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.SimpleUdfStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;

@PublicEvolving
public class StateBootstrapTransformation<T> {
    private final DataStream<T> stream;
    private final SavepointWriterOperatorFactory factory;
    @Nullable
    private final KeySelector<T, ?> keySelector;
    @Nullable
    private final TypeInformation<?> keyType;
    private final OptionalInt operatorMaxParallelism;

    StateBootstrapTransformation(DataStream<T> stream, OptionalInt operatorMaxParallelism, SavepointWriterOperatorFactory factory) {
        this.stream = stream;
        this.operatorMaxParallelism = operatorMaxParallelism;
        this.factory = factory;
        this.keySelector = null;
        this.keyType = null;
    }

    <K> StateBootstrapTransformation(DataStream<T> stream, OptionalInt operatorMaxParallelism, SavepointWriterOperatorFactory factory, @Nonnull KeySelector<T, K> keySelector, @Nonnull TypeInformation<K> keyType) {
        this.stream = stream;
        this.operatorMaxParallelism = operatorMaxParallelism;
        this.factory = factory;
        this.keySelector = keySelector;
        this.keyType = keyType;
    }

    int getMaxParallelism(int globalMaxParallelism) {
        return this.operatorMaxParallelism.orElse(globalMaxParallelism);
    }

    DataStream<OperatorState> writeOperatorState(OperatorIdentifier operatorIdentifier, StateBackend stateBackend, Configuration config, int globalMaxParallelism, Path savepointPath) {
        int localMaxParallelism = this.getMaxParallelism(globalMaxParallelism);
        return this.writeOperatorSubtaskStates(operatorIdentifier, stateBackend, config, savepointPath, localMaxParallelism).transform("reduce(OperatorSubtaskState)", TypeInformation.of(OperatorState.class), new GroupReduceOperator(new OperatorSubtaskStateReducer(operatorIdentifier, localMaxParallelism))).forceNonParallel();
    }

    @VisibleForTesting
    SingleOutputStreamOperator<TaggedOperatorSubtaskState> writeOperatorSubtaskStates(OperatorIdentifier operatorIdentifier, StateBackend stateBackend, Path savepointPath, int localMaxParallelism) {
        return this.writeOperatorSubtaskStates(operatorIdentifier, stateBackend, new Configuration(), savepointPath, localMaxParallelism);
    }

    private SingleOutputStreamOperator<TaggedOperatorSubtaskState> writeOperatorSubtaskStates(OperatorIdentifier operatorIdentifier, StateBackend stateBackend, Configuration additionalConfig, Path savepointPath, int localMaxParallelism) {
        StreamOperatorFactory operator = this.factory.createOperator(System.currentTimeMillis(), savepointPath);
        operator = (StreamOperatorFactory)this.stream.getExecutionEnvironment().clean(operator);
        StreamConfig config = this.getConfig(operatorIdentifier, stateBackend, additionalConfig, (StreamOperatorFactory<TaggedOperatorSubtaskState>)operator);
        BootstrapStreamTaskRunner operatorRunner = new BootstrapStreamTaskRunner(config, localMaxParallelism);
        KeyedStream input = this.stream;
        if (this.keySelector != null) {
            input = this.stream.keyBy(this.keySelector);
        }
        SingleOutputStreamOperator subtaskStates = input.transform(operatorIdentifier.getOperatorId().toHexString(), TypeInformation.of(TaggedOperatorSubtaskState.class), operatorRunner).setMaxParallelism(localMaxParallelism);
        if (operator instanceof SimpleUdfStreamOperatorFactory && ((SimpleUdfStreamOperatorFactory)operator).getOperator() instanceof BroadcastStateBootstrapOperator) {
            subtaskStates = subtaskStates.setParallelism(1);
        } else {
            int currentParallelism = StateBootstrapTransformation.getParallelism((SingleOutputStreamOperator<TaggedOperatorSubtaskState>)subtaskStates);
            if (currentParallelism > localMaxParallelism) {
                subtaskStates.setParallelism(localMaxParallelism);
            }
        }
        return subtaskStates;
    }

    @VisibleForTesting
    StreamConfig getConfig(OperatorIdentifier operatorIdentifier, StateBackend stateBackend, Configuration additionalConfig, StreamOperatorFactory<TaggedOperatorSubtaskState> operator) {
        Configuration deepCopy = new Configuration(MutableConfig.of(this.stream.getExecutionEnvironment().getConfiguration()));
        deepCopy.addAll(additionalConfig);
        StreamConfig config = new StreamConfig(deepCopy);
        config.setChainStart();
        config.setCheckpointingEnabled(true);
        config.setCheckpointMode(CheckpointingMode.EXACTLY_ONCE);
        if (this.keyType != null) {
            TypeSerializer keySerializer = this.keyType.createSerializer(this.stream.getExecutionEnvironment().getConfig().getSerializerConfig());
            config.setStateKeySerializer(keySerializer);
            config.setStatePartitioner(0, this.keySelector);
        }
        config.setStreamOperatorFactory(operator);
        config.setOperatorName(operatorIdentifier.getOperatorId().toHexString());
        config.setOperatorID(operatorIdentifier.getOperatorId());
        config.setStateBackend(stateBackend);
        config.setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase.STATE_BACKEND, 1.0);
        config.serializeAllConfigs();
        return config;
    }

    private static int getParallelism(SingleOutputStreamOperator<TaggedOperatorSubtaskState> subtaskStates) {
        int parallelism = subtaskStates.getParallelism();
        if (parallelism == -1) {
            parallelism = subtaskStates.getExecutionEnvironment().getParallelism();
        }
        return parallelism;
    }
}

