/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azurefs;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.azure.common.HadoopConfigLoader;
import org.apache.flink.fs.azurefs.AzureBlobFileSystem;
import org.apache.flink.fs.azurefs.AzureBlobStorageFSFactory;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureFSFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobStorageFSFactory.class);
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"fs.azure.", "azure."};
    private static final String HADOOP_CONFIG_PREFIX = "fs.azure.";
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[0][];
    private static final Set<String> PACKAGE_PREFIXES_TO_SHADE = Collections.emptySet();
    private static final Set<String> CONFIG_KEYS_TO_SHADE = Collections.emptySet();
    private static final String FLINK_SHADING_PREFIX = "";
    private final HadoopConfigLoader configLoader = new HadoopConfigLoader(FLINK_CONFIG_PREFIXES, MIRRORED_CONFIG_KEYS, "fs.azure.", PACKAGE_PREFIXES_TO_SHADE, CONFIG_KEYS_TO_SHADE, "");

    public void configure(Configuration config) {
        this.configLoader.setFlinkConfig(config);
    }

    abstract FileSystem createAzureFS();

    public org.apache.flink.core.fs.FileSystem create(URI fsUri) throws IOException {
        Preconditions.checkNotNull((Object)fsUri, (String)"passed file system URI object should not be null");
        LOG.info("Trying to load and instantiate Azure File System for {}", (Object)fsUri);
        org.apache.hadoop.conf.Configuration hadoopConfig = this.configLoader.getOrLoadHadoopConfig();
        FileSystem fs = this.createAzureFS();
        fs.initialize(fsUri, hadoopConfig);
        return new AzureBlobFileSystem(fs);
    }
}

