/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.legacy.sources.FilterableTableSource;
import org.apache.flink.table.legacy.sources.TableSource;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.rules.logical.ImmutablePushFilterIntoLegacyTableSourceScanRule;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.immutables.value.Value;
import scala.Tuple2;

@Value.Enclosing
public class PushFilterIntoLegacyTableSourceScanRule
extends RelRule<PushFilterIntoLegacyTableSourceScanRuleConfig> {
    public static final PushFilterIntoLegacyTableSourceScanRule INSTANCE = PushFilterIntoLegacyTableSourceScanRuleConfig.DEFAULT.toRule();

    private PushFilterIntoLegacyTableSourceScanRule(PushFilterIntoLegacyTableSourceScanRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        LegacyTableSourceTable tableSourceTable = scan.getTable().unwrap(LegacyTableSourceTable.class);
        if (tableSourceTable != null && tableSourceTable.tableSource() instanceof FilterableTableSource) {
            FilterableTableSource filterableSource = (FilterableTableSource)tableSourceTable.tableSource();
            return !filterableSource.isFilterPushedDown();
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        LegacyTableSourceTable table = scan.getTable().unwrap(LegacyTableSourceTable.class);
        this.pushFilterIntoScan(call, filter, scan, table);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkPreparingTableBase relOptTable) {
        RelBuilder relBuilder = call.builder();
        FlinkContext context = ShortcutUtils.unwrapContext(call);
        Tuple2<Expression[], RexNode[]> extracted = RexNodeExtractor.extractConjunctiveConditions(filter.getCondition(), filter.getInput().getRowType().getFieldNames(), relBuilder.getRexBuilder(), context.getFunctionCatalog(), context.getCatalogManager());
        Expression[] predicates = (Expression[])extracted._1;
        RexNode[] unconvertedRexNodes = (RexNode[])extracted._2;
        if (predicates.length == 0) {
            return;
        }
        LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
        Arrays.stream(predicates).forEach(e -> remainingPredicates.add((Expression)e));
        FlinkPreparingTableBase newRelOptTable = this.applyPredicate(remainingPredicates, relOptTable, relBuilder.getTypeFactory());
        TableSource newTableSource = newRelOptTable.unwrap(LegacyTableSourceTable.class).tableSource();
        TableSource oldTableSource = relOptTable.unwrap(LegacyTableSourceTable.class).tableSource();
        if (((FilterableTableSource)newTableSource).isFilterPushedDown() && newTableSource.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push filter into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newRelOptTable);
        if (remainingPredicates.isEmpty() && unconvertedRexNodes.length == 0) {
            call.transformTo(newScan);
        } else {
            relBuilder.push(scan);
            ExpressionConverter converter = new ExpressionConverter(relBuilder);
            List remainingConditions = remainingPredicates.stream().map(expr -> (RexNode)expr.accept((ExpressionVisitor)converter)).collect(Collectors.toList());
            Arrays.stream(unconvertedRexNodes).forEach(rexNode -> remainingConditions.add(rexNode));
            RexNode remainingCondition = (RexNode)remainingConditions.stream().reduce((xva$0, xva$1) -> relBuilder.and((RexNode)xva$0, (RexNode)xva$1)).get();
            RexNode simplifiedRemainingCondition = FlinkRexUtil.simplify(relBuilder.getRexBuilder(), remainingCondition, filter.getCluster().getPlanner().getExecutor());
            Filter newFilter = filter.copy(filter.getTraitSet(), newScan, simplifiedRemainingCondition);
            call.transformTo(newFilter);
        }
    }

    private FlinkPreparingTableBase applyPredicate(List<Expression> predicates, FlinkPreparingTableBase relOptTable, RelDataTypeFactory typeFactory) {
        int originPredicatesSize = predicates.size();
        LegacyTableSourceTable tableSourceTable = relOptTable.unwrap(LegacyTableSourceTable.class);
        FilterableTableSource filterableSource = (FilterableTableSource)tableSourceTable.tableSource();
        TableSource newTableSource = filterableSource.applyPredicate(predicates);
        int updatedPredicatesSize = predicates.size();
        FlinkStatistic statistic = tableSourceTable.getStatistic();
        FlinkStatistic newStatistic = originPredicatesSize == updatedPredicatesSize ? statistic : (statistic == FlinkStatistic.UNKNOWN() ? statistic : FlinkStatistic.builder().statistic(statistic).tableStats(null).build());
        return tableSourceTable.copy(newTableSource, newStatistic);
    }

    @Value.Immutable(singleton=false)
    public static interface PushFilterIntoLegacyTableSourceScanRuleConfig
    extends RelRule.Config {
        public static final PushFilterIntoLegacyTableSourceScanRuleConfig DEFAULT = ImmutablePushFilterIntoLegacyTableSourceScanRule.PushFilterIntoLegacyTableSourceScanRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(LogicalTableScan.class).noInputs())).withDescription("PushFilterIntoLegacyTableSourceScanRule");

        @Override
        default public PushFilterIntoLegacyTableSourceScanRule toRule() {
            return new PushFilterIntoLegacyTableSourceScanRule(this);
        }
    }
}

