/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.sources.DefinedProctimeAttribute;
import org.apache.flink.table.legacy.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.legacy.sources.NestedFieldsProjectableTableSource;
import org.apache.flink.table.legacy.sources.ProjectableTableSource;
import org.apache.flink.table.legacy.sources.TableSource;
import org.apache.flink.table.planner.plan.rules.logical.PushProjectIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.planner.plan.utils.RexNodeRewriter$;
import org.apache.flink.util.CollectionUtil;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0003\u0006\u00017!)1\u0005\u0001C\u0001I!)q\u0005\u0001C!Q!)A\u0007\u0001C!k\u001d)!H\u0003E\u0001w\u0019)\u0011B\u0003E\u0001y!)1%\u0002C\u0001\u0001\"9\u0011)\u0002b\u0001\n\u0003\u0011\u0005BB\"\u0006A\u0003%AD\u0001\u0015QkND\u0007K]8kK\u000e$\u0018J\u001c;p\u0019\u0016<\u0017mY=UC\ndWmU8ve\u000e,7kY1o%VdWM\u0003\u0002\f\u0019\u00059An\\4jG\u0006d'BA\u0007\u000f\u0003\u0015\u0011X\u000f\\3t\u0015\ty\u0001#\u0001\u0003qY\u0006t'BA\t\u0013\u0003\u001d\u0001H.\u00198oKJT!a\u0005\u000b\u0002\u000bQ\f'\r\\3\u000b\u0005U1\u0012!\u00024mS:\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00019A\u0011Q$I\u0007\u0002=)\u0011qb\b\u0006\u0003AY\tqaY1mG&$X-\u0003\u0002#=\tQ!+\u001a7PaR\u0014V\u000f\\3\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005Q\u0011aB7bi\u000eDWm\u001d\u000b\u0003S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012qAQ8pY\u0016\fg\u000eC\u00031\u0005\u0001\u0007\u0011'\u0001\u0003dC2d\u0007CA\u000f3\u0013\t\u0019dD\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\u0002\u000f=tW*\u0019;dQR\u0011a'\u000f\t\u0003U]J!\u0001O\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\r\u0001\r!M\u0001)!V\u001c\b\u000e\u0015:pU\u0016\u001cG/\u00138u_2+w-Y2z)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\t\u0003M\u0015\u0019\"!B\u001f\u0011\u0005)r\u0014BA ,\u0005\u0019\te.\u001f*fMR\t1(\u0001\u0005J\u001dN#\u0016IT\"F+\u0005a\u0012!C%O'R\u000bejQ#!\u0001")
public class PushProjectIntoLegacyTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushProjectIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        LegacyTableSourceTable legacyTableSourceTable = scan.getTable().unwrap(LegacyTableSourceTable.class);
        if (legacyTableSourceTable != null) {
            DefinedProctimeAttribute definedProctimeAttribute;
            DefinedRowtimeAttributes definedRowtimeAttributes;
            LegacyTableSourceTable legacyTableSourceTable2 = legacyTableSourceTable;
            TableSource tableSource = legacyTableSourceTable2.tableSource();
            if (tableSource instanceof DefinedRowtimeAttributes && !CollectionUtil.isNullOrEmpty((Collection)(definedRowtimeAttributes = (DefinedRowtimeAttributes)tableSource).getRowtimeAttributeDescriptors())) {
                return false;
            }
            if (tableSource instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)tableSource).getProctimeAttribute() != null) {
                return false;
            }
            if (tableSource instanceof ProjectableTableSource) {
                return true;
            }
            return tableSource instanceof NestedFieldsProjectableTableSource;
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Tuple2 tuple2;
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(project.getProjects());
        if (scan.getRowType().getFieldCount() == usedFields.length) {
            return;
        }
        LegacyTableSourceTable tableSourceTable = scan.getTable().unwrap(LegacyTableSourceTable.class);
        TableSource oldTableSource = tableSourceTable.tableSource();
        TableSource tableSource = oldTableSource;
        if (tableSource instanceof NestedFieldsProjectableTableSource) {
            TableSource tableSource2 = tableSource;
            List<String>[][] nestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(project.getProjects(), usedFields);
            tuple2 = new Tuple2((Object)((NestedFieldsProjectableTableSource)tableSource2).projectNestedFields(usedFields, (String[][])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nestedFields)).toStream().map((Function1 & Serializable & scala.Serializable)row -> (String[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).toStream().map((Function1 & Serializable & scala.Serializable)field -> String.join((CharSequence)".", field), Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (tableSource instanceof ProjectableTableSource) {
            TableSource tableSource3 = tableSource;
            tuple2 = new Tuple2((Object)((ProjectableTableSource)tableSource3).projectFields(usedFields), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (tableSource != null) {
            TableSource tableSource4 = tableSource;
            tuple2 = new Tuple2(tableSource4, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError(tableSource);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        TableSource newTableSource = (TableSource)tuple22._1();
        boolean isProjectSuccess = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)newTableSource, (Object)BoxesRunTime.boxToBoolean((boolean)isProjectSuccess));
        TableSource newTableSource2 = (TableSource)tuple23._1();
        boolean isProjectSuccess2 = tuple23._2$mcZ$sp();
        if (isProjectSuccess2 && newTableSource2.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push project into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        TableSchema tableSchema = oldTableSource.getTableSchema();
        TableSchema tableSchema2 = newTableSource2.getTableSchema();
        if (tableSchema == null ? tableSchema2 != null : !tableSchema.equals(tableSchema2)) {
            throw new TableException(new StringBuilder(140).append("TableSchema of ProjectableTableSource must not be modified by projectFields() call. This is a bug in the implementation of the TableSource ").append(oldTableSource.getClass().getCanonicalName()).append(".").toString());
        }
        LegacyTableSourceTable newTableSourceTable = tableSourceTable.copy(newTableSource2, usedFields);
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newTableSourceTable);
        List<RexNode> newProjects = RexNodeRewriter$.MODULE$.rewriteWithNewFieldInput(project.getProjects(), usedFields);
        Project newProject = project.copy(project.getTraitSet(), (RelNode)newScan, (List)newProjects, project.getRowType());
        if (ProjectRemoveRule.isTrivial(newProject)) {
            call.transformTo(newScan);
            return;
        }
        call.transformTo(newProject);
    }

    public PushProjectIntoLegacyTableSourceScanRule() {
        super(RelOptRule.operand(LogicalProject.class, RelOptRule.operand(LogicalTableScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushProjectIntoLegacyTableSourceScanRule");
    }
}

