/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.ml;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.AbstractFunctionRunner;
import org.apache.flink.util.Collector;

public class MLPredictRunner
extends AbstractFunctionRunner {
    private final GeneratedCollector<ListenableCollector<RowData>> generatedCollector;
    protected transient ListenableCollector<RowData> collector;

    public MLPredictRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedCollector<ListenableCollector<RowData>> generatedCollector) {
        super(generatedFetcher);
        this.generatedCollector = generatedCollector;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.collector = (ListenableCollector)((Object)this.generatedCollector.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        FunctionUtils.setFunctionRuntimeContext(this.collector, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.collector, (OpenContext)openContext);
    }

    public void processElement(RowData in, ProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.prepareCollector(in, out);
        this.fetcher.flatMap((Object)in, this.collector);
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.collector != null) {
            FunctionUtils.closeFunction(this.collector);
        }
    }

    public void prepareCollector(RowData in, Collector<RowData> out) {
        this.collector.setCollector(out);
        this.collector.setInput(in);
        this.collector.reset();
    }
}

