/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.CloseCQOperationContext;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.cache.operations.GetDurableCQsOperationContext;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.cache.operations.InvalidateOperationContext;
import org.apache.geode.cache.operations.KeySetOperationContext;
import org.apache.geode.cache.operations.PutAllOperationContext;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.operations.RegionClearOperationContext;
import org.apache.geode.cache.operations.RegionCreateOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.cache.operations.RemoveAllOperationContext;
import org.apache.geode.cache.operations.StopCQOperationContext;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.cache.operations.internal.GetOperationContextImpl;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassLoadUtils;
import org.apache.geode.internal.cache.operations.ContainsKeyOperationContext;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;
import org.jetbrains.annotations.NotNull;

public class AuthorizeRequest {
    private final AccessControl authzCallback;
    private final Principal principal;
    private final boolean isPrincipalSerializable;
    private ClientProxyMembershipID id;
    private final LogWriter logger;

    public AuthorizeRequest(String authzFactoryName, DistributedMember dm, Principal principal, Cache cache) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, NotAuthorizedException {
        this.principal = principal;
        this.isPrincipalSerializable = this.principal instanceof Serializable;
        this.logger = cache.getSecurityLogger();
        Method authzMethod = ClassLoadUtils.methodFromName(authzFactoryName);
        this.authzCallback = (AccessControl)authzMethod.invoke(null, (Object[])null);
        this.authzCallback.init(principal, dm, cache);
        this.id = null;
    }

    public AuthorizeRequest(String authzFactoryName, ClientProxyMembershipID id, Principal principal, Cache cache) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, NotAuthorizedException {
        this(authzFactoryName, id.getDistributedMember(), principal, cache);
        this.id = id;
        if (this.logger.infoEnabled()) {
            this.logger.info(String.format("AuthorizeRequest: Client[%s] is setting authorization callback to %s.", id, authzFactoryName));
        }
    }

    public GetOperationContext getAuthorize(String regionName, Object key, Object callbackArg) throws NotAuthorizedException {
        GetOperationContextImpl getContext = new GetOperationContextImpl(key, false);
        getContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, getContext)) {
            String errStr = String.format("Not authorized to perform GET operation on region [%s]", regionName);
            if (this.logger.fineEnabled()) {
                this.logger.warning(String.format("%s : %s", this, errStr));
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform GET operation on region [" + regionName + ']');
        }
        return getContext;
    }

    public PutOperationContext putAuthorize(String regionName, Object key, Object value, boolean isObject, Object callbackArg) throws NotAuthorizedException {
        return this.putAuthorize(regionName, key, value, isObject, callbackArg, (byte)0);
    }

    public PutOperationContext putAuthorize(String regionName, Object key, Object value, boolean isObject, Object callbackArg, byte opType) throws NotAuthorizedException {
        PutOperationContext putContext = new PutOperationContext(key, value, isObject, opType, false);
        putContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, putContext)) {
            String errStr = String.format("Not authorized to perform PUT operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform PUT operation on region [" + regionName + ']');
        }
        return putContext;
    }

    public PutAllOperationContext putAllAuthorize(String regionName, Map map, Object callbackArg) throws NotAuthorizedException {
        PutAllOperationContext putAllContext = new PutAllOperationContext(map);
        putAllContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, putAllContext)) {
            String errStr = String.format("Not authorized to perform PUTALL operation on region [%s]", regionName);
            if (this.logger.warningEnabled()) {
                this.logger.warning(String.format("%s : %s", this, errStr));
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform PUTALL operation on region [" + regionName + ']');
        }
        return putAllContext;
    }

    public RemoveAllOperationContext removeAllAuthorize(String regionName, Collection<?> keys, Object callbackArg) throws NotAuthorizedException {
        RemoveAllOperationContext removeAllContext = new RemoveAllOperationContext(keys);
        removeAllContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, removeAllContext)) {
            String errStr = String.format("Not authorized to perform removeAll operation on region [%s]", regionName);
            if (this.logger.warningEnabled()) {
                this.logger.warning(String.format("%s : %s", this, errStr));
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform removeAll operation on region [" + regionName + ']');
        }
        return removeAllContext;
    }

    public DestroyOperationContext destroyAuthorize(String regionName, Object key, Object callbackArg) throws NotAuthorizedException {
        DestroyOperationContext destroyEntryContext = new DestroyOperationContext(key);
        destroyEntryContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, destroyEntryContext)) {
            String errStr = String.format("Not authorized to perform DESTROY operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform DESTROY operation on region [" + regionName + ']');
        }
        return destroyEntryContext;
    }

    public QueryOperationContext queryAuthorize(String queryString, Set regionNames) throws NotAuthorizedException {
        return this.queryAuthorize(queryString, regionNames, null);
    }

    public QueryOperationContext queryAuthorize(String queryString, Set regionNames, Object[] queryParams) throws NotAuthorizedException {
        QueryOperationContext queryContext;
        if (regionNames == null) {
            regionNames = new HashSet();
        }
        if (!this.authzCallback.authorizeOperation(null, queryContext = new QueryOperationContext(queryString, regionNames, false, queryParams))) {
            String errStr = String.format("Not authorized to perfom QUERY operation [%s] on the cache", queryString);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform QUERY operation [" + queryString + "] on cache");
        }
        return queryContext;
    }

    public ExecuteCQOperationContext executeCQAuthorize(String cqName, String queryString, Set regionNames) throws NotAuthorizedException {
        ExecuteCQOperationContext executeCQContext;
        if (regionNames == null) {
            regionNames = new HashSet();
        }
        if (!this.authzCallback.authorizeOperation(null, executeCQContext = new ExecuteCQOperationContext(cqName, queryString, regionNames, false))) {
            String errStr = String.format("Not authorized to perfom EXECUTE_CQ operation [%s] on the cache", queryString);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform EXECUTE_CQ operation [" + queryString + "] on cache");
        }
        return executeCQContext;
    }

    public void stopCQAuthorize(String cqName, String queryString, Set regionNames) throws NotAuthorizedException {
        StopCQOperationContext stopCQContext = new StopCQOperationContext(cqName, queryString, regionNames);
        if (!this.authzCallback.authorizeOperation(null, stopCQContext)) {
            String errStr = String.format("Not authorized to perfom STOP_CQ operation [%s] on the cache", cqName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform STOP_CQ operation [" + cqName + ',' + queryString + "] on cache");
        }
    }

    public void closeCQAuthorize(String cqName, String queryString, Set regionNames) throws NotAuthorizedException {
        CloseCQOperationContext closeCQContext = new CloseCQOperationContext(cqName, queryString, regionNames);
        if (!this.authzCallback.authorizeOperation(null, closeCQContext)) {
            String errStr = String.format("Not authorized to perfom CLOSE_CQ operation [%s] on the cache", cqName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform CLOSE_CQ operation [" + cqName + ',' + queryString + "] on cache");
        }
    }

    public void getDurableCQsAuthorize() throws NotAuthorizedException {
        GetDurableCQsOperationContext getDurableCQsContext = new GetDurableCQsOperationContext();
        if (!this.authzCallback.authorizeOperation(null, getDurableCQsContext)) {
            String errStr = "Not authorized to perform GET_DURABLE_CQS operation on cache";
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform GET_DURABLE_CQS operation on cache");
        }
    }

    public RegionClearOperationContext clearAuthorize(String regionName, Object callbackArg) throws NotAuthorizedException {
        RegionClearOperationContext regionClearContext = new RegionClearOperationContext(false);
        regionClearContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, regionClearContext)) {
            String errStr = String.format("Not authorized to perform REGION_CLEAR operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform REGION_CLEAR operation on region [" + regionName + ']');
        }
        return regionClearContext;
    }

    public RegisterInterestOperationContext registerInterestAuthorize(String regionName, Object key, @NotNull InterestType interestType2, InterestResultPolicy policy) throws NotAuthorizedException {
        RegisterInterestOperationContext registerInterestContext = new RegisterInterestOperationContext(key, org.apache.geode.cache.operations.InterestType.fromOrdinal((byte)interestType2.ordinal()), policy);
        if (!this.authzCallback.authorizeOperation(regionName, registerInterestContext)) {
            String errStr = String.format("Not authorized to perform REGISTER_INTEREST operation for region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform REGISTER_INTEREST operation for region [" + regionName + ']');
        }
        return registerInterestContext;
    }

    public RegisterInterestOperationContext registerInterestListAuthorize(String regionName, List keys, InterestResultPolicy policy) throws NotAuthorizedException {
        RegisterInterestOperationContext registerInterestListContext = new RegisterInterestOperationContext(keys, org.apache.geode.cache.operations.InterestType.LIST, policy);
        if (!this.authzCallback.authorizeOperation(regionName, registerInterestListContext)) {
            String errStr = String.format("Not authorized to perform REGISTER_INTEREST_LIST operation for region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform REGISTER_INTEREST_LIST operation for region [" + regionName + ']');
        }
        return registerInterestListContext;
    }

    public UnregisterInterestOperationContext unregisterInterestAuthorize(String regionName, Object key, @NotNull InterestType interestType2) throws NotAuthorizedException {
        UnregisterInterestOperationContext unregisterInterestContext = new UnregisterInterestOperationContext(key, org.apache.geode.cache.operations.InterestType.fromOrdinal((byte)interestType2.ordinal()));
        if (!this.authzCallback.authorizeOperation(regionName, unregisterInterestContext)) {
            String errStr = String.format("Not authorized to perform UNREGISTER_INTEREST operation for region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform DESTROY operation on region [" + regionName + ']');
        }
        return unregisterInterestContext;
    }

    public UnregisterInterestOperationContext unregisterInterestListAuthorize(String regionName, List keys) throws NotAuthorizedException {
        UnregisterInterestOperationContext unregisterInterestListContext = new UnregisterInterestOperationContext(keys, org.apache.geode.cache.operations.InterestType.LIST);
        if (!this.authzCallback.authorizeOperation(regionName, unregisterInterestListContext)) {
            String errStr = String.format("Not authorized to perform UNREGISTER_INTEREST_LIST operation for region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform UNREGISTER_INTEREST_LIST operation for region [" + regionName + ']');
        }
        return unregisterInterestListContext;
    }

    public KeySetOperationContext keySetAuthorize(String regionName) throws NotAuthorizedException {
        KeySetOperationContext keySetContext = new KeySetOperationContext(false);
        if (!this.authzCallback.authorizeOperation(regionName, keySetContext)) {
            String errStr = String.format("Not authorized to perform KEY_SET operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform KEY_SET operation on region [" + regionName + ']');
        }
        return keySetContext;
    }

    public void containsKeyAuthorize(String regionName, Object key) throws NotAuthorizedException {
        ContainsKeyOperationContext containsKeyContext = new ContainsKeyOperationContext(key);
        if (!this.authzCallback.authorizeOperation(regionName, containsKeyContext)) {
            String errStr = String.format("Not authorized to perform CONTAINS_KEY operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform CONTAINS_KEY operation on region [" + regionName + ']');
        }
    }

    public void createRegionAuthorize(String regionName) throws NotAuthorizedException {
        RegionCreateOperationContext regionCreateContext = new RegionCreateOperationContext(false);
        if (!this.authzCallback.authorizeOperation(regionName, regionCreateContext)) {
            String errStr = String.format("Not authorized to perform CREATE_REGION operation for the region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform REGION_CREATE operation of region [" + regionName + ']');
        }
    }

    public RegionDestroyOperationContext destroyRegionAuthorize(String regionName, Object callbackArg) throws NotAuthorizedException {
        RegionDestroyOperationContext regionDestroyContext = new RegionDestroyOperationContext(false);
        regionDestroyContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, regionDestroyContext)) {
            String errStr = String.format("Not authorized to perform REGION_DESTROY operation for the region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform REGION_DESTROY operation for region [" + regionName + ']');
        }
        return regionDestroyContext;
    }

    public ExecuteFunctionOperationContext executeFunctionAuthorize(String functionName, String region, Set keySet, Object arguments, boolean optimizeForWrite) throws NotAuthorizedException {
        ExecuteFunctionOperationContext executeContext = new ExecuteFunctionOperationContext(functionName, region, keySet, arguments, optimizeForWrite, false);
        if (!this.authzCallback.authorizeOperation(region, executeContext)) {
            String errStr = "Not authorized to perform EXECUTE_REGION_FUNCTION operation";
            if (this.logger.warningEnabled()) {
                this.logger.warning(String.format("%s : %s", this, "Not authorized to perform EXECUTE_REGION_FUNCTION operation"));
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException("Not authorized to perform EXECUTE_REGION_FUNCTION operation", this.principal);
            }
            throw new NotAuthorizedException("Not authorized to perform EXECUTE_REGION_FUNCTION operation");
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform EXECUTE_REGION_FUNCTION operation ");
        }
        return executeContext;
    }

    public InvalidateOperationContext invalidateAuthorize(String regionName, Object key, Object callbackArg) throws NotAuthorizedException {
        InvalidateOperationContext invalidateEntryContext = new InvalidateOperationContext(key);
        invalidateEntryContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, invalidateEntryContext)) {
            String errStr = String.format("Not authorized to perform INVALIDATE operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this + ": Authorized to perform INVALIDATE operation on region [" + regionName + ']');
        }
        return invalidateEntryContext;
    }

    public void close() {
        this.authzCallback.close();
    }

    public String toString() {
        return (this.id == null ? "ClientProxyMembershipID not available" : this.id.toString()) + ",Principal:" + (this.principal == null ? "" : this.principal.getName());
    }
}

