/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;

public abstract class BaseTableRW<T extends BaseTable<T>> {
    private final String tableNameConfName;
    private final String defaultTableName;

    protected BaseTableRW(String tableNameConfName, String defaultTableName) {
        this.tableNameConfName = tableNameConfName;
        this.defaultTableName = defaultTableName;
    }

    public TypedBufferedMutator<T> getTableMutator(Configuration hbaseConf, Connection conn) throws IOException {
        TableName tableName = this.getTableName(hbaseConf);
        BufferedMutator bufferedMutator = conn.getBufferedMutator(tableName);
        TypedBufferedMutator table = new TypedBufferedMutator(bufferedMutator);
        return table;
    }

    public ResultScanner getResultScanner(Configuration hbaseConf, Connection conn, Scan scan) throws IOException {
        Table table = conn.getTable(this.getTableName(hbaseConf));
        return table.getScanner(scan);
    }

    public Result getResult(Configuration hbaseConf, Connection conn, Get get) throws IOException {
        Table table = conn.getTable(this.getTableName(hbaseConf));
        return table.get(get);
    }

    public static TableName getTableName(Configuration conf, String tableName) {
        String tableSchemaPrefix = conf.get("yarn.timeline-service.hbase-schema.prefix", "prod.");
        return TableName.valueOf((String)(tableSchemaPrefix + tableName));
    }

    public TableName getTableName(Configuration conf) {
        String tableName = conf.get(this.tableNameConfName, this.defaultTableName);
        return BaseTableRW.getTableName(conf, tableName);
    }

    public static TableName getTableName(Configuration conf, String tableNameInConf, String defaultTableName) {
        String tableName = conf.get(tableNameInConf, defaultTableName);
        return BaseTableRW.getTableName(conf, tableName);
    }

    public abstract void createTable(Admin var1, Configuration var2) throws IOException;
}

