/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.azure.cosmosdb.HashIndex;
import com.microsoft.azure.cosmosdb.Index;
import com.microsoft.azure.cosmosdb.IndexKind;
import com.microsoft.azure.cosmosdb.JsonSerializable;
import com.microsoft.azure.cosmosdb.RangeIndex;
import com.microsoft.azure.cosmosdb.SpatialIndex;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.text.WordUtils;

public class IncludedPath
extends JsonSerializable {
    private Collection<Index> indexes;

    public IncludedPath() {
    }

    public IncludedPath(String jsonString) {
        super(jsonString);
    }

    public String getPath() {
        return super.getString("path");
    }

    public void setPath(String path) {
        super.set("path", path);
    }

    public Collection<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = this.getIndexCollection();
            if (this.indexes == null) {
                this.indexes = new ArrayList<Index>();
            }
        }
        return this.indexes;
    }

    public void setIndexes(Collection<Index> indexes) {
        this.indexes = indexes;
    }

    private Collection<Index> getIndexCollection() {
        if (this.propertyBag != null && this.propertyBag.has("indexes")) {
            ArrayNode jsonArray = (ArrayNode)this.propertyBag.get("indexes");
            ArrayList<Index> result = new ArrayList<Index>();
            block5: for (int i = 0; i < jsonArray.size(); ++i) {
                JsonNode jsonObject = jsonArray.get(i);
                IndexKind indexKind = IndexKind.valueOf(WordUtils.capitalize((String)jsonObject.get("kind").asText()));
                switch (indexKind) {
                    case Hash: {
                        result.add(new HashIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case Range: {
                        result.add(new RangeIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case Spatial: {
                        result.add(new SpatialIndex(jsonObject.toString()));
                    }
                }
            }
            return result;
        }
        return null;
    }

    @Override
    void populatePropertyBag() {
        if (this.indexes != null) {
            for (Index index : this.indexes) {
                index.populatePropertyBag();
            }
            super.set("indexes", this.indexes);
        }
    }
}

