/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.server.namenode.visitor.NamespacePrintVisitor;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestFSImageWithOrderedSnapshotDeletion {
    static final long SEED = 0L;
    static final short NUM_DATANODES = 1;
    static final int BLOCKSIZE = 1024;
    private final Path dir;
    private static final String TEST_DIR = GenericTestUtils.getTestDir().getAbsolutePath();
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;
    private final PrintWriter output;
    private int printTreeCount;

    public TestFSImageWithOrderedSnapshotDeletion() {
        SnapshotTestHelper.disableLogs();
        GenericTestUtils.setLogLevel((Logger)INode.LOG, (Level)Level.TRACE);
        this.dir = new Path("/TestSnapshot");
        this.output = new PrintWriter(System.out, true);
        this.printTreeCount = 0;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.namenode.snapshot.deletion.ordered", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    void rename(Path src, Path dst) throws Exception {
        this.printTree("Before rename " + src + " -> " + dst);
        this.hdfs.rename(src, dst);
        this.printTree("After rename " + src + " -> " + dst);
    }

    void createFile(Path directory, String filename) throws Exception {
        Path f = new Path(directory, filename);
        DFSTestUtil.createFile((FileSystem)this.hdfs, f, 0L, (short)1, 0L);
    }

    void appendFile(Path directory, String filename) throws Exception {
        Path f = new Path(directory, filename);
        DFSTestUtil.appendFile((FileSystem)this.hdfs, f, "more data");
        this.printTree("appended " + f);
    }

    void deleteSnapshot(Path directory, String snapshotName) throws Exception {
        this.hdfs.deleteSnapshot(directory, snapshotName);
        this.printTree("deleted snapshot " + snapshotName);
    }

    @Test(timeout=60000L)
    public void testDoubleRename() throws Exception {
        Path parent = new Path("/parent");
        this.hdfs.mkdirs(parent);
        Path sub1 = new Path(parent, "sub1");
        Path sub1foo = new Path(sub1, "foo");
        this.hdfs.mkdirs(sub1);
        this.hdfs.mkdirs(sub1foo);
        this.createFile(sub1foo, "file0");
        this.printTree("before s0");
        this.hdfs.allowSnapshot(parent);
        this.hdfs.createSnapshot(parent, "s0");
        this.createFile(sub1foo, "file1");
        this.createFile(sub1foo, "file2");
        Path sub2 = new Path(parent, "sub2");
        this.hdfs.mkdirs(sub2);
        Path sub2foo = new Path(sub2, "foo");
        this.rename(sub1foo, sub2foo);
        this.hdfs.createSnapshot(parent, "s1");
        this.hdfs.createSnapshot(parent, "s2");
        this.printTree("created snapshots: s1, s2");
        this.appendFile(sub2foo, "file1");
        this.createFile(sub2foo, "file3");
        Path sub3 = new Path(parent, "sub3");
        this.hdfs.mkdirs(sub3);
        this.rename(sub2foo, sub3);
        this.hdfs.delete(sub3, true);
        this.printTree("deleted " + sub3);
        this.deleteSnapshot(parent, "s1");
        this.restartCluster();
        this.deleteSnapshot(parent, "s2");
        this.restartCluster();
    }

    private File getDumpTreeFile(String directory, String suffix) {
        return new File(directory, String.format("dumpTree_%s", suffix));
    }

    private File dumpTree2File(String fileSuffix) throws IOException {
        File file = this.getDumpTreeFile(TEST_DIR, fileSuffix);
        SnapshotTestHelper.dumpTree2File(this.fsn.getFSDirectory(), file);
        return file;
    }

    void restartCluster() throws Exception {
        File before = this.dumpTree2File("before.txt");
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        File after = this.dumpTree2File("after.txt");
        SnapshotTestHelper.compareDumpedTreeInFile(before, after, true);
    }

    String printTree(String label) throws Exception {
        this.output.println();
        this.output.println();
        this.output.println("***** " + this.printTreeCount++ + ": " + label);
        String b = this.fsn.getFSDirectory().getINode("/").dumpTreeRecursively().toString();
        this.output.println(b);
        String s = NamespacePrintVisitor.print2Sting((FSNamesystem)this.fsn);
        Assert.assertEquals((Object)b, (Object)s);
        return b;
    }

    @Test(timeout=60000L)
    public void testFSImageWithDoubleRename() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        Path dira = new Path(dir1, "dira");
        Path dirx = new Path(dir1, "dirx");
        Path dirb = new Path(dira, "dirb");
        this.hdfs.mkdirs(dira);
        this.hdfs.mkdirs(dirb);
        this.hdfs.mkdirs(dirx);
        this.hdfs.allowSnapshot(dir1);
        this.hdfs.createSnapshot(dir1, "s0");
        Path file1 = new Path(dirb, "file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)1, 0L);
        Path rennamePath = new Path(dirx, "dirb");
        this.hdfs.rename(dirb, rennamePath);
        this.hdfs.createSnapshot(dir1, "s1");
        DFSTestUtil.appendFile((FileSystem)this.hdfs, new Path("/dir1/dirx/dirb/file1"), "more data");
        Path renamePath1 = new Path(dir2, "dira");
        this.hdfs.mkdirs(renamePath1);
        this.hdfs.rename(rennamePath, renamePath1);
        this.hdfs.delete(renamePath1, true);
        this.hdfs.deleteSnapshot(dir1, "s1");
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testFSImageWithRename1() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        Path dira = new Path(dir1, "dira");
        Path dirx = new Path(dir1, "dirx");
        Path dirb = new Path(dirx, "dirb");
        this.hdfs.mkdirs(dira);
        this.hdfs.mkdirs(dirx);
        this.hdfs.allowSnapshot(dir1);
        this.hdfs.createSnapshot(dir1, "s0");
        this.hdfs.mkdirs(dirb);
        this.hdfs.createSnapshot(dir1, "s1");
        Path rennamePath = new Path(dira, "dirb");
        this.hdfs.rename(dirb, rennamePath);
        this.hdfs.createSnapshot(dir1, "s2");
        Path diry = new Path("/dir1/dira/dirb/diry");
        this.hdfs.mkdirs(diry);
        this.hdfs.createSnapshot(dir1, "s3");
        Path file1 = new Path("/dir1/dira/dirb/diry/file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(dir1, "s4");
        this.hdfs.delete(new Path("/dir1/dira/dirb"), true);
        this.hdfs.deleteSnapshot(dir1, "s1");
        this.hdfs.deleteSnapshot(dir1, "s3");
        Assert.assertTrue((boolean)this.hdfs.exists(new Path("/dir1/.snapshot/s4/dira/dirb/diry/file1")));
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testFSImageWithRename2() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        Path dira = new Path(dir1, "dira");
        Path dirx = new Path(dir1, "dirx");
        Path dirb = new Path(dirx, "dirb");
        this.hdfs.mkdirs(dira);
        this.hdfs.mkdirs(dirx);
        this.hdfs.allowSnapshot(dir1);
        this.hdfs.createSnapshot(dir1, "s0");
        this.hdfs.mkdirs(dirb);
        this.hdfs.createSnapshot(dir1, "s1");
        Path rennamePath = new Path(dira, "dirb");
        this.hdfs.rename(dirb, rennamePath);
        this.hdfs.createSnapshot(dir1, "s2");
        Path file1 = new Path("/dir1/dira/dirb/file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, new Path("/dir1/dira/dirb/file1"), 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(dir1, "s3");
        this.hdfs.deleteSnapshot(dir1, "s1");
        this.hdfs.deleteSnapshot(dir1, "s3");
        Assert.assertTrue((boolean)this.hdfs.exists(file1));
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testFSImageWithRename3() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        Path dira = new Path(dir1, "dira");
        Path dirx = new Path(dir1, "dirx");
        Path dirb = new Path(dirx, "dirb");
        this.hdfs.mkdirs(dira);
        this.hdfs.mkdirs(dirx);
        this.hdfs.allowSnapshot(dir1);
        this.hdfs.createSnapshot(dir1, "s0");
        this.hdfs.mkdirs(dirb);
        this.hdfs.createSnapshot(dir1, "s1");
        Path rennamePath = new Path(dira, "dirb");
        this.hdfs.rename(dirb, rennamePath);
        this.hdfs.createSnapshot(dir1, "s2");
        Path diry = new Path("/dir1/dira/dirb/diry");
        this.hdfs.mkdirs(diry);
        this.hdfs.createSnapshot(dir1, "s3");
        Path file1 = new Path("/dir1/dira/dirb/diry/file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(dir1, "s4");
        this.hdfs.delete(new Path("/dir1/dira/dirb"), true);
        this.hdfs.deleteSnapshot(dir1, "s1");
        this.hdfs.deleteSnapshot(dir1, "s3");
        Assert.assertTrue((boolean)this.hdfs.exists(new Path("/dir1/.snapshot/s4/dira/dirb/diry/file1")));
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testFSImageWithRename4() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        Path dira = new Path(dir1, "dira");
        Path dirx = new Path(dir1, "dirx");
        Path dirb = new Path(dirx, "dirb");
        this.hdfs.mkdirs(dira);
        this.hdfs.mkdirs(dirx);
        this.hdfs.allowSnapshot(dir1);
        this.hdfs.createSnapshot(dir1, "s0");
        this.hdfs.mkdirs(dirb);
        this.hdfs.createSnapshot(dir1, "s1");
        Path renamePath = new Path(dira, "dirb");
        this.hdfs.rename(dirb, renamePath);
        this.hdfs.createSnapshot(dir1, "s2");
        Path diry = new Path("/dir1/dira/dirb/diry");
        this.hdfs.mkdirs(diry);
        this.hdfs.createSnapshot(dir1, "s3");
        Path file1 = new Path("/dir1/dira/dirb/diry/file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(dir1, "s4");
        this.hdfs.delete(new Path("/dir1/dira/dirb/diry/file1"), false);
        this.hdfs.deleteSnapshot(dir1, "s1");
        this.hdfs.deleteSnapshot(dir1, "s3");
        Assert.assertTrue((boolean)this.hdfs.exists(new Path("/dir1/.snapshot/s4/dira/dirb/diry/file1")));
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test
    public void testFSImageWithRename5() throws Exception {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        this.hdfs.mkdirs(dir1);
        this.hdfs.mkdirs(dir2);
        Path dira = new Path(dir1, "dira");
        Path dirx = new Path(dir1, "dirx");
        Path dirb = new Path(dira, "dirb");
        Path dirc = new Path(dirb, "dirc");
        this.hdfs.mkdirs(dira);
        this.hdfs.mkdirs(dirb);
        this.hdfs.mkdirs(dirc);
        this.hdfs.mkdirs(dirx);
        this.hdfs.allowSnapshot(dir1);
        this.hdfs.createSnapshot(dir1, "s0");
        Path dird = new Path(dirc, "dird");
        Path dire = new Path(dird, "dire");
        Path file1 = new Path(dire, "file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)1, 0L);
        Path rennamePath = new Path(dirx, "dirb");
        this.hdfs.rename(dirb, rennamePath);
        this.hdfs.createSnapshot(dir1, "s1");
        DFSTestUtil.appendFile((FileSystem)this.hdfs, new Path("/dir1/dirx/dirb/dirc/dird/dire/file1"), "more data");
        Path renamePath1 = new Path(dir2, "dira");
        this.hdfs.mkdirs(renamePath1);
        this.hdfs.rename(rennamePath, renamePath1);
        this.hdfs.delete(renamePath1, true);
        this.hdfs.deleteSnapshot(dir1, "s1");
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testDoubleRenamesWithSnapshotDelete() throws Exception {
        Path sub1 = new Path(this.dir, "sub1");
        this.hdfs.mkdirs(sub1);
        this.hdfs.allowSnapshot(sub1);
        Path dir1 = new Path(sub1, "dir1");
        Path dir2 = new Path(sub1, "dir2");
        Path dir3 = new Path(sub1, "dir3");
        String snap3 = "snap3";
        String snap4 = "snap4";
        String snap5 = "snap5";
        String snap6 = "snap6";
        Path foo = new Path(dir2, "foo");
        Path bar = new Path(dir2, "bar");
        this.hdfs.createSnapshot(sub1, "snap1");
        this.hdfs.mkdirs(dir1, new FsPermission(511));
        this.rename(dir1, dir2);
        this.hdfs.createSnapshot(sub1, "snap2");
        DFSTestUtil.createFile((FileSystem)this.hdfs, foo, 1024L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(sub1, "snap3");
        this.hdfs.delete(foo, false);
        DFSTestUtil.createFile((FileSystem)this.hdfs, foo, 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(sub1, "snap4");
        this.hdfs.delete(foo, false);
        DFSTestUtil.createFile((FileSystem)this.hdfs, foo, 1024L, (short)1, 0L);
        this.hdfs.createSnapshot(sub1, "snap5");
        this.rename(dir2, dir3);
        this.hdfs.createSnapshot(sub1, "snap6");
        this.hdfs.delete(dir3, true);
        this.deleteSnapshot(sub1, "snap6");
        this.deleteSnapshot(sub1, "snap3");
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.restartNameNode(true);
    }
}

