/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;

public final class ColumnsSupplier<N extends Number>
implements Access2D<N>,
ElementsSupplier<N> {
    private final List<Access1D<N>> myColumns = new ArrayList<Access1D<N>>();
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final int myRowsCount;

    ColumnsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfRows) {
        this.myRowsCount = numberOfRows;
        this.myFactory = factory;
    }

    public PhysicalStore<N> addColumn() {
        PhysicalStore retVal = (PhysicalStore)this.myFactory.makeZero(this.myRowsCount, 1L);
        if (this.myColumns.add(retVal)) {
            return retVal;
        }
        return null;
    }

    public Access1D<N> addColumn(Access1D<N> column) {
        if (column.count() != (long)this.myRowsCount) {
            throw new IllegalArgumentException("All columns must have the same legth!");
        }
        if (this.myColumns.add(column)) {
            return column;
        }
        return null;
    }

    @Override
    public long countColumns() {
        return this.myColumns.size();
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myColumns.get((int)col).doubleValue(row);
    }

    @Override
    public N get(long row, long col) {
        return this.myColumns.get((int)col).get(row);
    }

    public Access1D<N> getColumn(int index) {
        return this.myColumns.get(index);
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myFactory;
    }

    public Access1D<N> removeColumn(int index) {
        return this.myColumns.remove(index);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        int tmpLimit = this.myColumns.size();
        for (int j = 0; j < tmpLimit; ++j) {
            receiver.fillColumn((long)j, this.myColumns.get(j));
        }
    }
}

