/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.util.ThreadFactoryUtil;

class OutOfBandScheduledExecutor {
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, ThreadFactoryUtil.threadFactory("scheduled")){

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> clbl, RunnableScheduledFuture<V> rsf) {
            return new OutOfBandRsf<V>(((ExecutorCarrier)((Object)clbl)).executor(), rsf);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable r, RunnableScheduledFuture<V> rsf) {
            return new OutOfBandRsf<V>(((ExecutorCarrier)((Object)r)).executor(), rsf);
        }
    };

    OutOfBandScheduledExecutor() {
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.scheduler.getQueue();
    }

    public ScheduledFuture<?> schedule(ExecutorService using, Runnable command, long delay, TimeUnit unit) {
        return this.scheduler.schedule(new ExecutorCarryingRunnable(using, command), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(ExecutorService using, Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduler.schedule(new ExecutorCarryingCallable<V>(using, callable), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ExecutorService using, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.scheduleAtFixedRate(new ExecutorCarryingRunnable(using, command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ExecutorService using, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleWithFixedDelay(new ExecutorCarryingRunnable(using, command), initialDelay, delay, unit);
    }

    public void shutdownNow() {
        this.scheduler.shutdownNow();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduler.awaitTermination(timeout, unit);
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    public boolean isTerminating() {
        return this.scheduler.isTerminating();
    }

    public boolean isTerminated() {
        return this.scheduler.isTerminated();
    }

    static class OutOfBandRsf<T>
    implements RunnableScheduledFuture<T> {
        private final ExecutorService worker;
        private final RunnableScheduledFuture<T> delegate;
        private volatile Future<?> execution;

        OutOfBandRsf(ExecutorService worker, RunnableScheduledFuture<T> original) {
            this.worker = worker;
            this.delegate = original;
        }

        public ExecutorService getExecutor() {
            return this.worker;
        }

        @Override
        public boolean isPeriodic() {
            return this.delegate.isPeriodic();
        }

        @Override
        public synchronized void run() {
            if (this.worker == null || this.worker.isShutdown()) {
                this.delegate.run();
            } else {
                this.execution = this.worker.submit(this.delegate);
            }
        }

        @Override
        public boolean cancel(boolean interrupt) {
            Future<?> currentExecution = this.execution;
            return (currentExecution == null || currentExecution.cancel(interrupt)) && this.delegate.cancel(interrupt);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)this.delegate.get();
        }

        @Override
        public T get(long l, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.delegate.get(l, tu);
        }

        @Override
        public long getDelay(TimeUnit tu) {
            return this.delegate.getDelay(tu);
        }

        @Override
        public int compareTo(Delayed t) {
            return this.delegate.compareTo(t);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }
    }

    static class ExecutorCarryingCallable<T>
    implements ExecutorCarrier,
    Callable<T> {
        private final ExecutorService executor;
        private final Callable<T> callable;

        public ExecutorCarryingCallable(ExecutorService executor, Callable<T> callable) {
            this.executor = executor;
            this.callable = callable;
        }

        @Override
        public ExecutorService executor() {
            return this.executor;
        }

        @Override
        public T call() throws Exception {
            return this.callable.call();
        }
    }

    static class ExecutorCarryingRunnable
    implements ExecutorCarrier,
    Runnable {
        private final ExecutorService executor;
        private final Runnable runnable;

        public ExecutorCarryingRunnable(ExecutorService executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        @Override
        public ExecutorService executor() {
            return this.executor;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }

    static interface ExecutorCarrier {
        public ExecutorService executor();
    }
}

