/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributeKeyPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeAttributePBImpl
extends NodeAttribute {
    private YarnProtos.NodeAttributeProto proto = YarnProtos.NodeAttributeProto.getDefaultInstance();
    private YarnProtos.NodeAttributeProto.Builder builder = null;
    private boolean viaProto = false;

    public NodeAttributePBImpl() {
        this.builder = YarnProtos.NodeAttributeProto.newBuilder();
    }

    public NodeAttributePBImpl(YarnProtos.NodeAttributeProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.NodeAttributeProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.NodeAttributeProto.newBuilder((YarnProtos.NodeAttributeProto)this.proto);
        }
        this.viaProto = false;
    }

    public NodeAttributeKey getAttributeKey() {
        YarnProtos.NodeAttributeProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAttributeKey()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getAttributeKey());
    }

    public void setAttributeKey(NodeAttributeKey attributeKey) {
        this.maybeInitBuilder();
        if (attributeKey == null) {
            this.builder.clearAttributeKey();
            return;
        }
        this.builder.setAttributeKey(this.convertToProtoFormat(attributeKey));
    }

    public String getAttributeValue() {
        YarnProtos.NodeAttributeProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAttributeValue()) {
            return null;
        }
        return p.getAttributeValue();
    }

    public void setAttributeValue(String attributeValue) {
        this.maybeInitBuilder();
        if (attributeValue == null) {
            this.builder.clearAttributeValue();
            return;
        }
        this.builder.setAttributeValue(attributeValue);
    }

    public NodeAttributeType getAttributeType() {
        YarnProtos.NodeAttributeProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAttributeType()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getAttributeType());
    }

    public void setAttributeType(NodeAttributeType attributeType) {
        this.maybeInitBuilder();
        if (attributeType == null) {
            this.builder.clearAttributeType();
            return;
        }
        this.builder.setAttributeType(this.convertToProtoFormat(attributeType));
    }

    private YarnProtos.NodeAttributeTypeProto convertToProtoFormat(NodeAttributeType attributeType) {
        return YarnProtos.NodeAttributeTypeProto.valueOf((String)attributeType.name());
    }

    private NodeAttributeType convertFromProtoFormat(YarnProtos.NodeAttributeTypeProto containerState) {
        return NodeAttributeType.valueOf((String)containerState.name());
    }

    private NodeAttributeKeyPBImpl convertFromProtoFormat(YarnProtos.NodeAttributeKeyProto attributeKeyProto) {
        return new NodeAttributeKeyPBImpl(attributeKeyProto);
    }

    private YarnProtos.NodeAttributeKeyProto convertToProtoFormat(NodeAttributeKey attributeKey) {
        return ((NodeAttributeKeyPBImpl)attributeKey).getProto();
    }

    public int hashCode() {
        return this.getAttributeKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NodeAttribute) {
            NodeAttribute other = (NodeAttribute)obj;
            return this.getAttributeKey().equals(other.getAttributeKey());
        }
        return false;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        NodeAttributeKey key = this.getAttributeKey();
        strBuilder.append(key.getAttributePrefix()).append("/").append(key.getAttributeName()).append("(").append(this.getAttributeType()).append(")=").append(this.getAttributeValue());
        return strBuilder.toString();
    }
}

