/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.util.Shell;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseClusterManager
extends Configured
implements ClusterManager {
    protected static final Logger LOG = LoggerFactory.getLogger(HBaseClusterManager.class);
    private String sshUserName;
    private String sshOptions;
    private static final String DEFAULT_TUNNEL_CMD = "timeout 30 /usr/bin/ssh %1$s %2$s%3$s%4$s \"sudo -u %6$s %5$s\"";
    private String tunnelCmd;
    private static final String DEFAULT_TUNNEL_SUDO_CMD = "timeout %6$s /usr/bin/ssh %1$s %2$s%3$s%4$s \"sudo %5$s\"";
    private String tunnelSudoCmd;
    static final String RETRY_ATTEMPTS_KEY = "hbase.it.clustermanager.retry.attempts";
    static final int DEFAULT_RETRY_ATTEMPTS = 5;
    static final String RETRY_SLEEP_INTERVAL_KEY = "hbase.it.clustermanager.retry.sleep.interval";
    static final int DEFAULT_RETRY_SLEEP_INTERVAL = 1000;
    protected RetryCounterFactory retryCounterFactory;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.sshUserName = conf.get("hbase.it.clustermanager.ssh.user", "");
        String extraSshOptions = conf.get("hbase.it.clustermanager.ssh.opts", "");
        this.sshOptions = System.getenv("HBASE_SSH_OPTS");
        if (!extraSshOptions.isEmpty()) {
            this.sshOptions = StringUtils.join((Object[])new Object[]{this.sshOptions, extraSshOptions}, (String)" ");
        }
        this.sshOptions = this.sshOptions == null ? "" : this.sshOptions;
        this.sshUserName = this.sshUserName == null ? "" : this.sshUserName;
        this.tunnelCmd = conf.get("hbase.it.clustermanager.ssh.cmd", DEFAULT_TUNNEL_CMD);
        this.tunnelSudoCmd = conf.get("hbase.it.clustermanager.ssh.sudo.cmd", DEFAULT_TUNNEL_SUDO_CMD);
        if (this.sshUserName != null && this.sshUserName.length() > 0 || this.sshOptions != null && this.sshOptions.length() > 0) {
            LOG.info("Running with SSH user [" + this.sshUserName + "] and options [" + this.sshOptions + "]");
        }
        this.retryCounterFactory = new RetryCounterFactory(new RetryCounter.RetryConfig().setMaxAttempts(conf.getInt(RETRY_ATTEMPTS_KEY, 5)).setSleepInterval(conf.getLong(RETRY_SLEEP_INTERVAL_KEY, 1000L)));
    }

    protected String getServiceUser(ClusterManager.ServiceType service) {
        Configuration conf = this.getConf();
        switch (service) {
            case HADOOP_DATANODE: 
            case HADOOP_NAMENODE: {
                return conf.get("hbase.it.clustermanager.hadoop.hdfs.user", "hdfs");
            }
            case ZOOKEEPER_SERVER: {
                return conf.get("hbase.it.clustermanager.zookeeper.user", "zookeeper");
            }
        }
        return conf.get("hbase.it.clustermanager.hbase.user", "hbase");
    }

    protected CommandProvider getCommandProvider(ClusterManager.ServiceType service) throws IOException {
        switch (service) {
            case HADOOP_DATANODE: 
            case HADOOP_NAMENODE: {
                return new HadoopShellCommandProvider(this.getConf());
            }
            case ZOOKEEPER_SERVER: {
                return new ZookeeperShellCommandProvider(this.getConf());
            }
        }
        Class provider = this.getConf().getClass("hbase.it.clustermanager.hbase.command.provider", HBaseShellCommandProvider.class, CommandProvider.class);
        return (CommandProvider)ReflectionUtils.newInstance((Class)provider, (Object[])new Object[]{this.getConf()});
    }

    protected Pair<Integer, String> exec(String hostname, ClusterManager.ServiceType service, String ... cmd) throws IOException {
        LOG.info("Executing remote command: {}, hostname:{}", (Object)StringUtils.join((Object[])cmd, (String)" "), (Object)hostname);
        RemoteShell shell = new RemoteShell(hostname, this.getServiceUser(service), cmd);
        try {
            shell.execute();
        }
        catch (Shell.ExitCodeException ex) {
            String output = shell.getOutput();
            throw new Shell.ExitCodeException(ex.getExitCode(), "stderr: " + ex.getMessage() + ", stdout: " + output);
        }
        LOG.info("Executed remote command, exit code:{} , output:{}", (Object)shell.getExitCode(), (Object)shell.getOutput());
        return new Pair((Object)shell.getExitCode(), (Object)shell.getOutput());
    }

    private Pair<Integer, String> execWithRetries(String hostname, ClusterManager.ServiceType service, String ... cmd) throws IOException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.exec(hostname, service, cmd);
            }
            catch (IOException e) {
                this.retryOrThrow(retryCounter, e, hostname, cmd);
                try {
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.warn("Sleep Interrupted:", (Throwable)ex);
                    continue;
                }
            }
            break;
        }
    }

    public Pair<Integer, String> execSudo(String hostname, long timeout, String ... cmd) throws IOException {
        LOG.info("Executing remote command: {} , hostname:{}", (Object)StringUtils.join((Object[])cmd, (String)" "), (Object)hostname);
        RemoteSudoShell shell = new RemoteSudoShell(hostname, cmd, timeout);
        try {
            shell.execute();
        }
        catch (Shell.ExitCodeException ex) {
            String output = shell.getOutput();
            throw new Shell.ExitCodeException(ex.getExitCode(), "stderr: " + ex.getMessage() + ", stdout: " + output);
        }
        LOG.info("Executed remote command, exit code:{} , output:{}", (Object)shell.getExitCode(), (Object)shell.getOutput());
        return new Pair((Object)shell.getExitCode(), (Object)shell.getOutput());
    }

    public Pair<Integer, String> execSudoWithRetries(String hostname, long timeout, String ... cmd) throws IOException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.execSudo(hostname, timeout, cmd);
            }
            catch (IOException e) {
                this.retryOrThrow(retryCounter, e, hostname, cmd);
                try {
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.warn("Sleep Interrupted:", (Throwable)ex);
                    continue;
                }
            }
            break;
        }
    }

    private <E extends Exception> void retryOrThrow(RetryCounter retryCounter, E ex, String hostname, String[] cmd) throws E {
        if (retryCounter.shouldRetry()) {
            LOG.warn("Remote command: " + StringUtils.join((Object[])cmd, (String)" ") + " , hostname:" + hostname + " failed at attempt " + retryCounter.getAttemptTimes() + ". Retrying until maxAttempts: " + retryCounter.getMaxAttempts() + ". Exception: " + ex.getMessage());
            return;
        }
        throw ex;
    }

    private void exec(String hostname, ClusterManager.ServiceType service, CommandProvider.Operation op) throws IOException {
        this.execWithRetries(hostname, service, this.getCommandProvider(service).getCommand(service, op));
    }

    @Override
    public void start(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.exec(hostname, service, CommandProvider.Operation.START);
    }

    @Override
    public void stop(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.exec(hostname, service, CommandProvider.Operation.STOP);
    }

    @Override
    public void restart(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.exec(hostname, service, CommandProvider.Operation.RESTART);
    }

    public void signal(ClusterManager.ServiceType service, Signal signal, String hostname) throws IOException {
        this.execWithRetries(hostname, service, this.getCommandProvider(service).signalCommand(service, signal.toString()));
    }

    @Override
    public boolean isRunning(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String ret = (String)this.execWithRetries(hostname, service, this.getCommandProvider(service).isRunningCommand(service)).getSecond();
        return ret.length() > 0;
    }

    @Override
    public void kill(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.signal(service, Signal.SIGKILL, hostname);
    }

    @Override
    public void suspend(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.signal(service, Signal.SIGSTOP, hostname);
    }

    @Override
    public void resume(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.signal(service, Signal.SIGCONT, hostname);
    }

    @Override
    public boolean isSuspended(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String ret = (String)this.execWithRetries(hostname, service, this.getCommandProvider(service).getStateCommand(service)).getSecond();
        return ret != null && ret.trim().equals("T");
    }

    @Override
    public boolean isResumed(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String ret = (String)this.execWithRetries(hostname, service, this.getCommandProvider(service).getStateCommand(service)).getSecond();
        return ret != null && !ret.trim().equals("T");
    }

    static class ZookeeperShellCommandProvider
    extends CommandProvider {
        private final String zookeeperHome;

        ZookeeperShellCommandProvider(Configuration conf) throws IOException {
            this.zookeeperHome = conf.get("hbase.it.clustermanager.zookeeper.home", System.getenv("ZOOBINDIR"));
            if (this.zookeeperHome == null) {
                throw new IOException("ZooKeeper home configuration parameter i.e. 'hbase.it.clustermanager.zookeeper.home' is not configured properly.");
            }
        }

        @Override
        public String getCommand(ClusterManager.ServiceType service, CommandProvider.Operation op) {
            return String.format("%s/bin/zkServer.sh %s", this.zookeeperHome, op.toString().toLowerCase(Locale.ROOT));
        }

        @Override
        protected String findPidCommand(ClusterManager.ServiceType service) {
            return String.format("ps ux | grep %s | grep -v grep | tr -s ' ' | cut -d ' ' -f2", new Object[]{service});
        }
    }

    static class HadoopShellCommandProvider
    extends CommandProvider {
        private final String hadoopHome;
        private final String confDir;

        HadoopShellCommandProvider(Configuration conf) throws IOException {
            this.hadoopHome = conf.get("hbase.it.clustermanager.hadoop.home", System.getenv("HADOOP_HOME"));
            String tmp = conf.get("hbase.it.clustermanager.hadoop.conf.dir", System.getenv("HADOOP_CONF_DIR"));
            if (this.hadoopHome == null) {
                throw new IOException("Hadoop home configuration parameter i.e. 'hbase.it.clustermanager.hadoop.home' is not configured properly.");
            }
            this.confDir = tmp != null ? String.format("--config %s", tmp) : "";
        }

        @Override
        public String getCommand(ClusterManager.ServiceType service, CommandProvider.Operation op) {
            return String.format("%s/sbin/hadoop-daemon.sh %s %s %s", new Object[]{this.hadoopHome, this.confDir, op.toString().toLowerCase(Locale.ROOT), service});
        }
    }

    static class HBaseShellCommandProvider
    extends CommandProvider {
        private final String hbaseHome;
        private final String confDir;

        HBaseShellCommandProvider(Configuration conf) {
            this.hbaseHome = conf.get("hbase.it.clustermanager.hbase.home", System.getenv("HBASE_HOME"));
            String tmp = conf.get("hbase.it.clustermanager.hbase.conf.dir", System.getenv("HBASE_CONF_DIR"));
            this.confDir = tmp != null ? String.format("--config %s", tmp) : "";
        }

        @Override
        public String getCommand(ClusterManager.ServiceType service, CommandProvider.Operation op) {
            return String.format("%s/bin/hbase-daemon.sh %s %s %s", new Object[]{this.hbaseHome, this.confDir, op.toString().toLowerCase(Locale.ROOT), service});
        }
    }

    static abstract class CommandProvider {
        CommandProvider() {
        }

        public abstract String getCommand(ClusterManager.ServiceType var1, Operation var2);

        public String isRunningCommand(ClusterManager.ServiceType service) {
            return this.findPidCommand(service);
        }

        protected String findPidCommand(ClusterManager.ServiceType service) {
            return String.format("ps ux | grep proc_%s | grep -v grep | tr -s ' ' | cut -d ' ' -f2", new Object[]{service});
        }

        protected String getStateCommand(ClusterManager.ServiceType service) {
            return String.format("%s | xargs ps -o state= -p ", this.findPidCommand(service));
        }

        public String signalCommand(ClusterManager.ServiceType service, String signal) {
            return String.format("%s | xargs kill -s %s", this.findPidCommand(service), signal);
        }

        static enum Operation {
            START,
            STOP,
            RESTART;

        }
    }

    protected class RemoteSudoShell
    extends Shell.ShellCommandExecutor {
        private String hostname;

        public RemoteSudoShell(String hostname, String[] execString, long timeout) {
            this(hostname, execString, null, null, timeout);
        }

        public RemoteSudoShell(String hostname, String[] execString, File dir, Map<String, String> env, long timeout) {
            super(execString, dir, env, timeout);
            this.hostname = hostname;
        }

        public String[] getExecString() {
            String at = HBaseClusterManager.this.sshUserName.isEmpty() ? "" : "@";
            String remoteCmd = StringUtils.join((Object[])super.getExecString(), (String)" ");
            String cmd = String.format(HBaseClusterManager.this.tunnelSudoCmd, HBaseClusterManager.this.sshOptions, HBaseClusterManager.this.sshUserName, at, this.hostname, remoteCmd, Float.valueOf((float)this.timeOutInterval / 1000.0f));
            LOG.info("Executing full command [" + cmd + "]");
            return new String[]{"/usr/bin/env", "bash", "-c", cmd};
        }
    }

    protected class RemoteShell
    extends Shell.ShellCommandExecutor {
        private String hostname;
        private String user;

        public RemoteShell(String hostname, String[] execString, File dir, Map<String, String> env, long timeout) {
            super(execString, dir, env, timeout);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String[] execString, File dir, Map<String, String> env) {
            super(execString, dir, env);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String[] execString, File dir) {
            super(execString, dir);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String[] execString) {
            super(execString);
            this.hostname = hostname;
        }

        public RemoteShell(String hostname, String user, String[] execString) {
            super(execString);
            this.hostname = hostname;
            this.user = user;
        }

        public String[] getExecString() {
            String at = HBaseClusterManager.this.sshUserName.isEmpty() ? "" : "@";
            String remoteCmd = StringUtils.join((Object[])super.getExecString(), (String)" ");
            String cmd = String.format(HBaseClusterManager.this.tunnelCmd, HBaseClusterManager.this.sshOptions, HBaseClusterManager.this.sshUserName, at, this.hostname, remoteCmd, this.user);
            LOG.info("Executing full command [" + cmd + "]");
            return new String[]{"/usr/bin/env", "bash", "-c", cmd};
        }
    }

    protected static enum Signal {
        SIGKILL,
        SIGSTOP,
        SIGCONT;

    }
}

