/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.TimeFrames;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.CompositeSingleOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.IntervalOperandTypeChecker;
import org.apache.calcite.sql.type.LiteralOperandTypeChecker;
import org.apache.calcite.sql.type.MultisetOperandTypeChecker;
import org.apache.calcite.sql.type.OperandMetadataImpl;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SameOperandTypeExceptLastOperandChecker;
import org.apache.calcite.sql.type.SetopOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class OperandTypes {
    private static final Set<TimeUnitRange> TIME_UNITS = ImmutableSet.of((Object)TimeUnitRange.HOUR, (Object)TimeUnitRange.MINUTE, (Object)TimeUnitRange.SECOND);
    private static final Set<TimeUnitRange> MONTH_UNITS = ImmutableSet.of((Object)TimeUnitRange.MILLENNIUM, (Object)TimeUnitRange.CENTURY, (Object)TimeUnitRange.DECADE, (Object)TimeUnitRange.YEAR, (Object)TimeUnitRange.ISOYEAR, (Object)TimeUnitRange.QUARTER, (Object[])new TimeUnitRange[]{TimeUnitRange.MONTH});
    private static final Set<TimeUnitRange> DAY_UNITS = ImmutableSet.of((Object)TimeUnitRange.WEEK, (Object)TimeUnitRange.DAY);
    private static final Set<TimeUnitRange> DATE_UNITS = ImmutableSet.builder().addAll(MONTH_UNITS).addAll(DAY_UNITS).build();
    private static final Set<TimeUnitRange> TIMESTAMP_UNITS = ImmutableSet.builder().addAll(DATE_UNITS).addAll(TIME_UNITS).build();
    private static final Set<String> WEEK_FRAMES = ImmutableSet.builder().addAll(TimeFrames.WEEK_FRAME_NAMES).add((Object)"ISOWEEK").add((Object)"WEEK").build();
    public static final SqlSingleOperandTypeChecker NILADIC = OperandTypes.family(new SqlTypeFamily[0]);
    public static final SqlOperandTypeChecker VARIADIC = OperandTypes.variadic(SqlOperandCountRanges.any());
    public static final SqlOperandTypeChecker ONE_OR_MORE = OperandTypes.variadic(SqlOperandCountRanges.from(1));
    public static final SqlSingleOperandTypeChecker BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker BOOLEAN_BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker INTEGER = OperandTypes.family(SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker NUMERIC_OPTIONAL_INTEGER = OperandTypes.family((List<SqlTypeFamily>)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.INTEGER), (Integer number) -> number == 1);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTEGER = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker NUMERIC_NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC_EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker BINARY = OperandTypes.family(SqlTypeFamily.BINARY);
    public static final SqlSingleOperandTypeChecker STRING = OperandTypes.family(SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_OPTIONAL_STRING = OperandTypes.family((List<SqlTypeFamily>)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING), (Integer number) -> number == 2);
    public static final FamilyOperandTypeChecker STRING_NUMERIC_OPTIONAL_STRING = OperandTypes.family((List<SqlTypeFamily>)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.STRING), (Integer number) -> number == 2);
    public static final SqlSingleOperandTypeChecker CHARACTER = OperandTypes.family(SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker DATE = OperandTypes.family(SqlTypeFamily.DATE);
    public static final SqlSingleOperandTypeChecker TIME = OperandTypes.family(SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker TIMESTAMP = OperandTypes.family(SqlTypeFamily.TIMESTAMP);
    public static final SqlSingleOperandTypeChecker INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker CHARACTER_CHARACTER_DATETIME = OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker PERIOD = new PeriodOperandTypeChecker();
    public static final SqlSingleOperandTypeChecker PERIOD_OR_DATETIME = PERIOD.or(DATETIME);
    public static final FamilyOperandTypeChecker INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker MULTISET = OperandTypes.family(SqlTypeFamily.MULTISET);
    public static final SqlSingleOperandTypeChecker ARRAY = OperandTypes.family(SqlTypeFamily.ARRAY);
    public static final SqlSingleOperandTypeChecker COLLECTION = OperandTypes.family(SqlTypeFamily.MULTISET).or(OperandTypes.family(SqlTypeFamily.ARRAY));
    public static final SqlSingleOperandTypeChecker COLLECTION_OR_MAP = OperandTypes.family(SqlTypeFamily.MULTISET).or(OperandTypes.family(SqlTypeFamily.ARRAY)).or(OperandTypes.family(SqlTypeFamily.MAP));
    public static final SqlSingleOperandTypeChecker NULLABLE_LITERAL = new LiteralOperandTypeChecker(true);
    public static final SqlSingleOperandTypeChecker LITERAL = new LiteralOperandTypeChecker(false);
    public static final SqlSingleOperandTypeChecker POSITIVE_INTEGER_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)node;
            BigDecimal value = arg.getValueAs(BigDecimal.class);
            if (value.compareTo(BigDecimal.ZERO) < 0 || this.hasFractionalPart(value)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBePositiveInteger(callBinding.getOperator().getName()));
                }
                return false;
            }
            if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.numberLiteralOutOfRange(value.toString()));
                }
                return false;
            }
            return true;
        }

        private boolean hasFractionalPart(BigDecimal bd) {
            return bd.precision() - bd.scale() <= 0;
        }
    };
    public static final SqlSingleOperandTypeChecker UNIT_INTERVAL_NUMERIC_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)node;
            BigDecimal value = arg.getValueAs(BigDecimal.class);
            if (value.compareTo(BigDecimal.ZERO) < 0 || value.compareTo(BigDecimal.ONE) > 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBeNumericLiteralInRange(callBinding.getOperator().getName(), 0, 1));
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlSingleOperandTypeChecker SAME_SAME = new SameOperandTypeChecker(2);
    public static final SqlSingleOperandTypeChecker SAME_SAME_INTEGER = new SameOperandTypeExceptLastOperandChecker(3, "INTEGER");
    public static final SqlSingleOperandTypeChecker SAME_SAME_SAME = new SameOperandTypeChecker(3);
    public static final SqlOperandTypeChecker SAME_VARIADIC = new SameOperandTypeChecker(-1);
    public static final SqlOperandTypeChecker AT_LEAST_ONE_SAME_VARIADIC = new SameOperandTypeChecker(-1){

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.from(1);
        }
    };
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED_COMPARABLE_ORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.COMPARE);
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED = new ComparableOperandTypeChecker(1, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.NONE);
    public static final SqlOperandTypeChecker COMPARABLE_UNORDERED_COMPARABLE_UNORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.UNORDERED, SqlOperandTypeChecker.Consistency.LEAST_RESTRICTIVE);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME = STRING_STRING.and(SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_SAME = STRING_STRING_STRING.and(SAME_SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER_OPTIONAL_INTEGER = OperandTypes.family((List<SqlTypeFamily>)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER), (Integer i) -> i == 2);
    public static final SqlSingleOperandTypeChecker STRING_NUMERIC = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker STRING_NUMERIC_NUMERIC = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker CBSTRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER).or(OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.INTEGER));
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_INTEGER = STRING_STRING_INTEGER.and(SAME_SAME_INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_OR_ARRAY_SAME_SAME = OperandTypes.or(STRING_SAME_SAME, OperandTypes.and(SAME_SAME, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY)));
    public static final SqlSingleOperandTypeChecker ANY = OperandTypes.family(SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_ANY = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_IGNORE = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.IGNORE);
    public static final SqlSingleOperandTypeChecker IGNORE_ANY = OperandTypes.family(SqlTypeFamily.IGNORE, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_NUMERIC = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker ANY_NUMERIC_ANY = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_STRING_STRING = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final SqlOperandTypeChecker ANY_COMPARABLE = new SqlOperandTypeChecker(){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            this.getOperandCountRange().isValidCount(callBinding.getOperandCount());
            RelDataType type = callBinding.getOperandType(1);
            return type.getComparability() == RelDataTypeComparability.ALL;
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(2);
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(<ANY>, <COMPARABLE_TYPE>)";
        }
    };
    public static final SqlSingleOperandTypeChecker CURSOR = OperandTypes.family(SqlTypeFamily.CURSOR);
    public static final SqlOperandTypeChecker MEASURE = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.ANY), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            if (!super.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            @Nullable SqlValidatorScope scope = callBinding.getScope();
            if (scope != null && !scope.isMeasureRef(node)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationError(Static.RESOURCE.argumentMustBeMeasure(callBinding.getOperator().getName()));
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlSingleOperandTypeChecker INTERVAL_SAME_SAME = INTERVAL_INTERVAL.and(SAME_SAME);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTERVAL = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker INTERVAL_NUMERIC = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker TIME_INTERVAL = OperandTypes.family(SqlTypeFamily.TIME, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker TIMESTAMP_INTERVAL = OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATE_INTERVAL = OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_INTERVAL_TIME = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_TIME = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker INTERVAL_DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker INTERVALINTERVAL_INTERVALDATETIME = INTERVAL_SAME_SAME.or(INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker PLUS_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_SAME_SAME).or(DATETIME_INTERVAL).or(INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker MULTIPLY_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_NUMERIC).or(NUMERIC_INTERVAL);
    public static final SqlSingleOperandTypeChecker DIVISION_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_NUMERIC);
    public static final SqlSingleOperandTypeChecker MINUS_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_SAME_SAME).or(DATETIME_INTERVAL);
    public static final FamilyOperandTypeChecker MINUS_DATE_OPERATOR = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.DATETIME_INTERVAL), i -> false){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
                return false;
            }
            return SAME_SAME.checkOperandTypes(callBinding, throwOnFailure);
        }
    };
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_INTERVAL = NUMERIC.or(INTERVAL);
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_STRING = NUMERIC.or(STRING);
    public static final SqlSingleOperandTypeChecker RECORD_COLLECTION = new RecordTypeWithOneFieldChecker(sqlTypeName -> sqlTypeName != SqlTypeName.ARRAY && sqlTypeName != SqlTypeName.MULTISET){

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)";
        }
    };
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION = COLLECTION.or(RECORD_COLLECTION);
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION_OR_MAP = COLLECTION_OR_MAP.or(new RecordTypeWithOneFieldChecker(sqlTypeName -> sqlTypeName != SqlTypeName.MULTISET && sqlTypeName != SqlTypeName.ARRAY && sqlTypeName != SqlTypeName.MAP){

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)\nUNNEST(<ARRAY>)\nUNNEST(<MAP>)";
        }
    });
    public static final SqlOperandTypeChecker MULTISET_MULTISET = new MultisetOperandTypeChecker();
    public static final SqlOperandTypeChecker SET_OP = new SetopOperandTypeChecker();
    public static final SqlOperandTypeChecker RECORD_TO_SCALAR = new SqlSingleOperandTypeChecker(){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"RECORDTYPE(SINGLE FIELD)"));
        }
    };

    private OperandTypes() {
    }

    public static FamilyOperandTypeChecker family(SqlTypeFamily ... families) {
        return new FamilyOperandTypeChecker((List<SqlTypeFamily>)ImmutableList.copyOf((Object[])families), i -> false);
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families, Predicate<Integer> optional) {
        return new FamilyOperandTypeChecker(families, optional);
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families) {
        return OperandTypes.family(families, (Integer i) -> false);
    }

    public static SqlSingleOperandTypeChecker interval(Iterable<TimeUnitRange> ranges) {
        ImmutableSet set = ImmutableSet.copyOf(ranges);
        return new IntervalOperandTypeChecker(arg_0 -> OperandTypes.lambda$interval$2((Set)set, arg_0));
    }

    public static SqlSingleOperandTypeChecker dateInterval() {
        return new IntervalOperandTypeChecker(intervalQualifier -> DATE_UNITS.contains(intervalQualifier.timeUnitRange) || WEEK_FRAMES.contains(intervalQualifier.timeFrameName));
    }

    public static SqlSingleOperandTypeChecker timeInterval() {
        return new IntervalOperandTypeChecker(intervalQualifier -> TIME_UNITS.contains(intervalQualifier.timeUnitRange));
    }

    public static SqlSingleOperandTypeChecker timestampInterval() {
        return new IntervalOperandTypeChecker(intervalQualifier -> TIMESTAMP_UNITS.contains(intervalQualifier.timeUnitRange) || WEEK_FRAMES.contains(intervalQualifier.timeFrameName));
    }

    public static SqlOperandMetadata operandMetadata(List<SqlTypeFamily> families, Function<RelDataTypeFactory, List<RelDataType>> typesFactory, IntFunction<String> operandName, Predicate<Integer> optional) {
        return new OperandMetadataImpl(families, typesFactory, operandName, optional);
    }

    public static SqlOperandTypeChecker or(SqlOperandTypeChecker ... rules) {
        return OperandTypes.composite(CompositeOperandTypeChecker.Composition.OR, (List<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null, null, null);
    }

    public static SqlOperandTypeChecker and(SqlOperandTypeChecker ... rules) {
        return OperandTypes.and_((Iterable<SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules));
    }

    private static SqlOperandTypeChecker and_(Iterable<SqlOperandTypeChecker> rules) {
        return OperandTypes.composite(CompositeOperandTypeChecker.Composition.AND, (List<? extends SqlOperandTypeChecker>)ImmutableList.copyOf(rules), null, null, null);
    }

    public static SqlSingleOperandTypeChecker or(SqlSingleOperandTypeChecker ... rules) {
        return OperandTypes.compositeSingle(CompositeOperandTypeChecker.Composition.OR, (List<? extends SqlSingleOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null);
    }

    public static SqlSingleOperandTypeChecker and(SqlSingleOperandTypeChecker ... rules) {
        return OperandTypes.compositeSingle(CompositeOperandTypeChecker.Composition.AND, (List<? extends SqlSingleOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null);
    }

    private static SqlSingleOperandTypeChecker compositeSingle(CompositeOperandTypeChecker.Composition composition, List<? extends SqlSingleOperandTypeChecker> allowedRules, @Nullable String allowedSignatures) {
        ArrayList<? extends SqlSingleOperandTypeChecker> list = new ArrayList<SqlSingleOperandTypeChecker>(allowedRules);
        switch (composition) {
            default: {
                break;
            }
            case AND: 
            case OR: {
                OperandTypes.flatten(list, c -> c instanceof CompositeSingleOperandTypeChecker && ((CompositeSingleOperandTypeChecker)c).composition == composition ? ((CompositeSingleOperandTypeChecker)c).getRules() : null);
            }
        }
        if (list.size() == 1) {
            return (SqlSingleOperandTypeChecker)list.get(0);
        }
        return new CompositeSingleOperandTypeChecker(composition, (ImmutableList<? extends SqlSingleOperandTypeChecker>)ImmutableList.copyOf(list), allowedSignatures);
    }

    public static SqlOperandTypeChecker sequence(String allowedSignatures, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.SEQUENCE, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), allowedSignatures, null, null);
    }

    public static SqlOperandTypeChecker repeat(SqlOperandCountRange range, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.REPEAT, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null, null, range);
    }

    public static SqlOperandTypeChecker nth(int ordinal, int operandCount, SqlSingleOperandTypeChecker rule) {
        Object[] rules = new SqlSingleOperandTypeChecker[operandCount];
        Arrays.fill(rules, ANY);
        rules[ordinal] = rule;
        return OperandTypes.sequence("", (SqlSingleOperandTypeChecker[])rules);
    }

    static SqlOperandTypeChecker composite(CompositeOperandTypeChecker.Composition composition, List<? extends SqlOperandTypeChecker> allowedRules, @Nullable String allowedSignatures, @Nullable BiFunction<SqlOperator, String, String> signatureGenerator, @Nullable SqlOperandCountRange range) {
        ArrayList<? extends SqlOperandTypeChecker> list = new ArrayList<SqlOperandTypeChecker>(allowedRules);
        switch (composition) {
            default: {
                break;
            }
            case AND: 
            case OR: {
                OperandTypes.flatten(list, c -> c instanceof CompositeOperandTypeChecker && ((CompositeOperandTypeChecker)c).composition == composition ? ((CompositeOperandTypeChecker)c).getRules() : null);
            }
        }
        if (list.size() == 1) {
            return (SqlOperandTypeChecker)list.get(0);
        }
        return new CompositeOperandTypeChecker(composition, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf(list), allowedSignatures, signatureGenerator, range);
    }

    private static <E> void flatten(List<E> list, Function<E, @Nullable List<? extends E>> expander) {
        int i = 0;
        while (i < list.size()) {
            @Nullable List<? extends E> list2 = expander.apply(list.get(i));
            if (list2 == null) {
                ++i;
                continue;
            }
            list.remove(i);
            list.addAll(i, list2);
        }
    }

    public static SqlOperandTypeChecker variadic(final SqlOperandCountRange range) {
        return new SqlOperandTypeChecker(){

            @Override
            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return range.isValidCount(callBinding.getOperandCount());
            }

            @Override
            public SqlOperandCountRange getOperandCountRange() {
                return range;
            }

            @Override
            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(...)";
            }
        };
    }

    public static SqlSingleOperandTypeChecker same(int operandCount, int ... ordinals) {
        final ImmutableIntList ordinalList = ImmutableIntList.of(ordinals);
        Preconditions.checkArgument((ordinalList.size() >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)Util.isDistinct(ordinalList));
        return new SameOperandTypeChecker(operandCount){

            @Override
            protected List<Integer> getOperandList(int operandCount) {
                return ordinalList;
            }
        };
    }

    private static /* synthetic */ boolean lambda$interval$2(Set set, SqlIntervalQualifier intervalQualifier) {
        return set.contains(intervalQualifier.timeUnitRange);
    }

    private static class PeriodOperandTypeChecker
    implements SqlSingleOperandTypeChecker {
        private PeriodOperandTypeChecker() {
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean valid = false;
            if (type.isStruct() && type.getFieldList().size() == 2) {
                RelDataType t0 = type.getFieldList().get(0).getType();
                RelDataType t1 = type.getFieldList().get(1).getType();
                if (SqlTypeUtil.isDatetime(t0)) {
                    if (SqlTypeUtil.isDatetime(t1)) {
                        if (SqlTypeUtil.sameNamedType(t0, t1)) {
                            valid = true;
                        }
                    } else if (SqlTypeUtil.isInterval(t1)) {
                        valid = true;
                    }
                }
            }
            if (!valid && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return valid;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"PERIOD (DATETIME, INTERVAL)", (Object)"PERIOD (DATETIME, DATETIME)"));
        }
    }

    private static abstract class RecordTypeWithOneFieldChecker
    implements SqlSingleOperandTypeChecker {
        private final Predicate<SqlTypeName> typeNamePredicate;

        private RecordTypeWithOneFieldChecker(Predicate<SqlTypeName> predicate) {
            this.typeNamePredicate = predicate;
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            } else {
                SqlTypeName typeName = type.getFieldList().get(0).getType().getSqlTypeName();
                if (this.typeNamePredicate.test(typeName)) {
                    validationError = true;
                }
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }
    }
}

