/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.BaseHTTPClient;
import org.apache.iceberg.rest.ErrorHandler;
import org.apache.iceberg.rest.ExponentialHttpRequestRetryStrategy;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.ImmutableHTTPRequest;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient
extends BaseHTTPClient {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPClient.class);
    @VisibleForTesting
    static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    @VisibleForTesting
    static final String CLIENT_GIT_COMMIT_SHORT_HEADER = "X-Client-Git-Commit-Short";
    private static final String REST_MAX_RETRIES = "rest.client.max-retries";
    static final String REST_MAX_CONNECTIONS = "rest.client.max-connections";
    static final int REST_MAX_CONNECTIONS_DEFAULT = 100;
    static final String REST_MAX_CONNECTIONS_PER_ROUTE = "rest.client.connections-per-route";
    static final int REST_MAX_CONNECTIONS_PER_ROUTE_DEFAULT = 100;
    @VisibleForTesting
    static final String REST_CONNECTION_TIMEOUT_MS = "rest.client.connection-timeout-ms";
    @VisibleForTesting
    static final String REST_SOCKET_TIMEOUT_MS = "rest.client.socket-timeout-ms";
    private final URI baseUri;
    private final CloseableHttpClient httpClient;
    private final Map<String, String> baseHeaders;
    private final ObjectMapper mapper;
    private final AuthSession authSession;
    private final boolean isRootClient;

    private HTTPClient(URI baseUri, HttpHost proxy, CredentialsProvider proxyCredsProvider, Map<String, String> baseHeaders, ObjectMapper objectMapper, Map<String, String> properties, HttpClientConnectionManager connectionManager, AuthSession session) {
        this.baseUri = baseUri;
        this.baseHeaders = baseHeaders;
        this.mapper = objectMapper;
        this.authSession = session;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setConnectionManager(connectionManager);
        int maxRetries = PropertyUtil.propertyAsInt(properties, REST_MAX_RETRIES, 5);
        clientBuilder.setRetryStrategy((HttpRequestRetryStrategy)new ExponentialHttpRequestRetryStrategy(maxRetries));
        if (proxy != null) {
            if (proxyCredsProvider != null) {
                clientBuilder.setDefaultCredentialsProvider(proxyCredsProvider);
            }
            clientBuilder.setProxy(proxy);
        }
        this.httpClient = clientBuilder.build();
        this.isRootClient = true;
    }

    private HTTPClient(HTTPClient parent, AuthSession authSession) {
        this.baseUri = parent.baseUri;
        this.httpClient = parent.httpClient;
        this.mapper = parent.mapper;
        this.baseHeaders = parent.baseHeaders;
        this.authSession = authSession;
        this.isRootClient = false;
    }

    @Override
    public HTTPClient withAuthSession(AuthSession session) {
        Preconditions.checkNotNull(session, "Invalid auth session: null");
        return new HTTPClient(this, session);
    }

    private static String extractResponseBodyAsString(CloseableHttpResponse response) {
        try {
            if (response.getEntity() == null) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | ParseException e) {
            throw new RESTException(e, "Failed to convert HTTP response body to string", new Object[0]);
        }
    }

    private static boolean isSuccessful(CloseableHttpResponse response) {
        int code = response.getCode();
        return code == 200 || code == 202 || code == 204;
    }

    private static ErrorResponse buildDefaultErrorResponse(CloseableHttpResponse response) {
        String responseReason = response.getReasonPhrase();
        String message = responseReason != null && !responseReason.isEmpty() ? responseReason : EnglishReasonPhraseCatalog.INSTANCE.getReason(response.getCode(), null);
        String type = "RESTException";
        return ErrorResponse.builder().responseCode(response.getCode()).withMessage(message).withType(type).build();
    }

    private static void throwFailure(CloseableHttpResponse response, String responseBody, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse errorResponse = null;
        if (responseBody != null) {
            try {
                if (errorHandler instanceof ErrorHandler) {
                    errorResponse = ((ErrorHandler)errorHandler).parseResponse(response.getCode(), responseBody);
                } else {
                    LOG.warn("Unknown error handler {}, response body won't be parsed", (Object)errorHandler.getClass().getName());
                    errorResponse = ErrorResponse.builder().responseCode(response.getCode()).withMessage(responseBody).build();
                }
            }
            catch (UncheckedIOException | IllegalArgumentException e) {
                LOG.error("Failed to parse an error response. Will create one instead.", (Throwable)e);
            }
        }
        if (errorResponse == null) {
            errorResponse = HTTPClient.buildDefaultErrorResponse(response);
        }
        errorHandler.accept(errorResponse);
        throw new RESTException("Unhandled error: %s", errorResponse);
    }

    @Override
    protected HTTPRequest buildRequest(HTTPRequest.HTTPMethod method, String path, Map<String, String> queryParams, Map<String, String> headers, Object body) {
        ImmutableHTTPRequest.Builder builder = ImmutableHTTPRequest.builder().baseUri(this.baseUri).mapper(this.mapper).method(method).path(path).body(body).queryParameters(queryParams == null ? Map.of() : queryParams);
        LinkedHashMap<String, String> allHeaders = Maps.newLinkedHashMap();
        if (headers != null) {
            allHeaders.putAll(headers);
        }
        allHeaders.putIfAbsent("Accept", ContentType.APPLICATION_JSON.getMimeType());
        ContentType mimeType = body instanceof Map ? ContentType.APPLICATION_FORM_URLENCODED : ContentType.APPLICATION_JSON;
        allHeaders.putIfAbsent("Content-Type", mimeType.getMimeType());
        if (this.baseHeaders != null) {
            this.baseHeaders.forEach(allHeaders::putIfAbsent);
        }
        Preconditions.checkState(this.authSession != null, "Invalid auth session: null");
        return this.authSession.authenticate(builder.headers(HTTPHeaders.of(allHeaders)).build());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T extends RESTResponse> T execute(HTTPRequest req, Class<T> responseType, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        HttpUriRequestBase request = new HttpUriRequestBase(req.method().name(), req.requestUri());
        req.headers().entries().forEach(e -> request.addHeader(e.name(), (Object)e.value()));
        String encodedBody = req.encodedBody();
        if (encodedBody != null) {
            request.setEntity((HttpEntity)new StringEntity(encodedBody));
        }
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
            RESTResponse rESTResponse;
            HashMap<String, String> respHeaders = Maps.newHashMap();
            for (Header header : response.getHeaders()) {
                respHeaders.put(header.getName(), header.getValue());
            }
            responseHeaders.accept(respHeaders);
            if (response.getCode() == 204 || responseType == null && HTTPClient.isSuccessful(response)) {
                Header[] headerArray = null;
                return (T)headerArray;
            }
            String responseBody = HTTPClient.extractResponseBodyAsString(response);
            if (!HTTPClient.isSuccessful(response)) {
                HTTPClient.throwFailure(response, responseBody, errorHandler);
            }
            if (responseBody == null) {
                throw new RESTException("Invalid (null) response body for request (expected %s): method=%s, path=%s, status=%d", new Object[]{responseType.getSimpleName(), req.method(), req.path(), response.getCode()});
            }
            try {
                rESTResponse = (RESTResponse)this.mapper.readValue(responseBody, responseType);
            }
            catch (JsonProcessingException e2) {
                throw new RESTException(e2, "Received a success response code of %d, but failed to parse response body into %s", response.getCode(), responseType.getSimpleName());
            }
            return (T)rESTResponse;
        }
        catch (IOException e3) {
            throw new RESTException(e3, "Error occurred while processing %s request", new Object[]{req.method()});
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isRootClient) {
            this.httpClient.close(CloseMode.GRACEFUL);
        }
    }

    static HttpClientConnectionManager configureConnectionManager(Map<String, String> properties) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        ConnectionConfig connectionConfig = HTTPClient.configureConnectionConfig(properties);
        if (connectionConfig != null) {
            connectionManagerBuilder.setDefaultConnectionConfig(connectionConfig);
        }
        return connectionManagerBuilder.useSystemProperties().setMaxConnTotal(Integer.getInteger(REST_MAX_CONNECTIONS, PropertyUtil.propertyAsInt(properties, REST_MAX_CONNECTIONS, 100)).intValue()).setMaxConnPerRoute(PropertyUtil.propertyAsInt(properties, REST_MAX_CONNECTIONS_PER_ROUTE, 100)).build();
    }

    @VisibleForTesting
    static ConnectionConfig configureConnectionConfig(Map<String, String> properties) {
        Long connectionTimeoutMillis = PropertyUtil.propertyAsNullableLong(properties, REST_CONNECTION_TIMEOUT_MS);
        Integer socketTimeoutMillis = PropertyUtil.propertyAsNullableInt(properties, REST_SOCKET_TIMEOUT_MS);
        if (connectionTimeoutMillis == null && socketTimeoutMillis == null) {
            return null;
        }
        ConnectionConfig.Builder connConfigBuilder = ConnectionConfig.custom();
        if (connectionTimeoutMillis != null) {
            connConfigBuilder.setConnectTimeout(connectionTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
        }
        if (socketTimeoutMillis != null) {
            connConfigBuilder.setSocketTimeout(socketTimeoutMillis.intValue(), TimeUnit.MILLISECONDS);
        }
        return connConfigBuilder.build();
    }

    public static Builder builder(Map<String, String> properties) {
        return new Builder(properties);
    }

    public static class Builder {
        private final Map<String, String> properties;
        private final Map<String, String> baseHeaders = Maps.newHashMap();
        private URI uri;
        private ObjectMapper mapper = RESTObjectMapper.mapper();
        private HttpHost proxy;
        private CredentialsProvider proxyCredentialsProvider;
        private AuthSession authSession;

        private Builder(Map<String, String> properties) {
            this.properties = properties;
        }

        public Builder uri(String baseUri) {
            Preconditions.checkNotNull(baseUri, "Invalid uri for http client: null");
            try {
                this.uri = URI.create(RESTUtil.stripTrailingSlash(baseUri));
            }
            catch (IllegalArgumentException e) {
                throw new RESTException(e, "Failed to create request URI from base %s", baseUri);
            }
            return this;
        }

        public Builder uri(URI baseUri) {
            Preconditions.checkNotNull(baseUri, "Invalid uri for http client: null");
            this.uri = baseUri;
            return this;
        }

        public Builder withProxy(String hostname, int port) {
            Preconditions.checkNotNull(hostname, "Invalid hostname for http client proxy: null");
            this.proxy = new HttpHost(hostname, port);
            return this;
        }

        public Builder withProxyCredentialsProvider(CredentialsProvider credentialsProvider) {
            Preconditions.checkNotNull(credentialsProvider, "Invalid credentials provider for http client proxy: null");
            this.proxyCredentialsProvider = credentialsProvider;
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.baseHeaders.put(key, value);
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.baseHeaders.putAll(headers);
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.mapper = objectMapper;
            return this;
        }

        public Builder withAuthSession(AuthSession session) {
            this.authSession = session;
            return this;
        }

        public HTTPClient build() {
            this.withHeader(HTTPClient.CLIENT_VERSION_HEADER, IcebergBuild.fullVersion());
            this.withHeader(HTTPClient.CLIENT_GIT_COMMIT_SHORT_HEADER, IcebergBuild.gitCommitShortId());
            if (this.proxyCredentialsProvider != null) {
                Preconditions.checkNotNull(this.proxy, "Invalid http client proxy for proxy credentials provider: null");
            }
            return new HTTPClient(this.uri, this.proxy, this.proxyCredentialsProvider, this.baseHeaders, this.mapper, this.properties, HTTPClient.configureConnectionManager(this.properties), this.authSession);
        }
    }
}

