/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.atlas;

import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClient;
import org.apache.hadoop.hive.ql.exec.repl.atlas.RetryingClientTimeBased;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasRestClientImpl
extends RetryingClientTimeBased
implements AtlasRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasRestClientImpl.class);
    private final AtlasClientV2 clientV2;

    public AtlasRestClientImpl(AtlasClientV2 clientV2, HiveConf conf) {
        this.clientV2 = clientV2;
        this.totalDurationInSeconds = conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION, TimeUnit.SECONDS);
        this.initialDelayInSeconds = conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY, TimeUnit.SECONDS);
        this.maxRetryDelayInSeconds = conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES, TimeUnit.SECONDS);
        this.backOff = conf.getFloatVar(HiveConf.ConfVars.REPL_RETRY_BACKOFF_COEFFICIENT);
        this.maxJitterInSeconds = (int)conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_JITTER, TimeUnit.SECONDS);
    }

    private <T> T runWithTimeout(Callable<T> callable, long timeout, TimeUnit timeUnit) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(callable);
        executor.shutdown();
        try {
            return future.get(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new IllegalStateException(t);
        }
    }

    @Override
    public InputStream exportData(final AtlasExportRequest request) throws SemanticException {
        LOG.debug("exportData: {}" + String.valueOf(request));
        return this.invokeWithRetry(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                SecurityUtils.reloginExpiringKeytabUser();
                return AtlasRestClientImpl.this.clientV2.exportData(request);
            }
        });
    }

    @Override
    public AtlasImportResult importData(final AtlasImportRequest request, AtlasReplInfo atlasReplInfo) throws Exception {
        AtlasImportResult defaultResult = this.getDefaultAtlasImportResult(request);
        final Path exportFilePath = new Path(atlasReplInfo.getStagingDir(), "atlas_export.zip");
        final FileSystem fs = FileSystem.get((URI)exportFilePath.toUri(), (Configuration)atlasReplInfo.getConf());
        if (!fs.exists(exportFilePath)) {
            LOG.info("There is nothing to load, returning the default result.");
            return defaultResult;
        }
        LOG.debug("Atlas import data request: {}" + String.valueOf(request));
        return this.invokeWithRetry(new Callable<AtlasImportResult>(){

            @Override
            public AtlasImportResult call() throws Exception {
                try (InputStream is = null;){
                    SecurityUtils.reloginExpiringKeytabUser();
                    is = fs.open(exportFilePath);
                    AtlasImportResult atlasImportResult = AtlasRestClientImpl.this.clientV2.importData(request, is);
                    return atlasImportResult;
                }
            }
        });
    }

    private AtlasImportResult getDefaultAtlasImportResult(AtlasImportRequest request) {
        return new AtlasImportResult(request, "", "", "", 0L);
    }

    @Override
    public AtlasServer getServer(String endpoint, HiveConf conf) throws SemanticException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(AtlasServiceException.class).build();
        try {
            return retryable.executeCallable(() -> {
                try {
                    return this.clientV2.getServer(endpoint);
                }
                catch (AtlasServiceException e) {
                    int statusCode;
                    int n = statusCode = e.getStatus() != null ? e.getStatus().getStatusCode() : -1;
                    if (ClientResponse.Status.NOT_FOUND.getStatusCode() == statusCode) {
                        LOG.info("Atlas server entity is not found");
                        return null;
                    }
                    throw e;
                }
            });
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public String getEntityGuid(String entityType, final String attributeName, final String qualifiedName) throws SemanticException {
        int entityApiTimeOut = 10;
        HashMap<String, String> attributes = new HashMap<String, String>(){
            {
                this.put(attributeName, qualifiedName);
            }
        };
        try {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.runWithTimeout(() -> this.clientV2.getEntityByAttribute(entityType, attributes), entityApiTimeOut, TimeUnit.SECONDS);
            if (entityWithExtInfo == null || entityWithExtInfo.getEntity() == null) {
                LOG.warn("Atlas entity cannot be retrieved using: type: {} and {} - {}", new Object[]{entityType, attributeName, qualifiedName});
                return null;
            }
            return entityWithExtInfo.getEntity().getGuid();
        }
        catch (AtlasServiceException e) {
            int statusCode;
            int n = statusCode = e.getStatus() != null ? e.getStatus().getStatusCode() : -1;
            if (statusCode != ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_INTERNAL_CONFIG_FOR_SERVICE.format(new String[]{"Exception while getEntityGuid ", "atlas"}), e.getCause());
            }
            LOG.warn("getEntityGuid: Could not retrieve entity guid for: {}-{}-{}", new Object[]{entityType, attributeName, qualifiedName, e.getMessage()});
            return null;
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    @Override
    public boolean getStatus(HiveConf conf) throws SemanticException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(Exception.class).build();
        try {
            return retryable.executeCallable(() -> this.clientV2.isServerReady());
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), (Throwable)e);
        }
    }
}

