/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSDatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSFunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSPartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSTableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.load.EventDumpDirComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseEventsIterator
implements Iterator<BootstrapEvent> {
    private static Logger LOG = LoggerFactory.getLogger(DatabaseEventsIterator.class);
    private RemoteIterator<LocatedFileStatus> remoteIterator;
    private final Path dbLevelPath;
    private HiveConf hiveConf;
    ReplicationState replicationState;
    private Path next = null;
    private Path previous = null;
    private boolean databaseEventProcessed = false;

    DatabaseEventsIterator(Path dbLevelPath, HiveConf hiveConf) throws IOException {
        this.dbLevelPath = dbLevelPath;
        this.hiveConf = hiveConf;
        FileSystem fileSystem = dbLevelPath.getFileSystem((Configuration)hiveConf);
        if (!fileSystem.exists(new Path(dbLevelPath, "_metadata"))) {
            this.databaseEventProcessed = true;
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_REPL_TEST_FILES_SORTED)) {
            LOG.info(" file sorting is enabled in DatabaseEventsIterator");
            final ArrayList<LocatedFileStatus> fileStatuses = new ArrayList<LocatedFileStatus>();
            this.getSortedFileList(dbLevelPath, fileStatuses, fileSystem);
            this.remoteIterator = new RemoteIterator<LocatedFileStatus>(){
                private int idx = 0;
                private final int numEntry = fileStatuses.size();
                private final List<LocatedFileStatus> fileStatusesLocal = fileStatuses;

                public boolean hasNext() throws IOException {
                    return this.idx < this.numEntry;
                }

                public LocatedFileStatus next() throws IOException {
                    LOG.info(" file in next is " + String.valueOf(this.fileStatusesLocal.get(this.idx)));
                    return this.fileStatusesLocal.get(this.idx++);
                }
            };
        } else {
            this.remoteIterator = fileSystem.listFiles(dbLevelPath, true);
        }
    }

    private void getSortedFileList(Path eventPath, List<LocatedFileStatus> fileStatuses, FileSystem fileSystem) throws IOException {
        RemoteIterator iteratorNext = fileSystem.listFiles(eventPath, false);
        while (iteratorNext.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)iteratorNext.next();
            LOG.info(" files added at getSortedFileList" + String.valueOf(status.getPath()));
            fileStatuses.add(status);
        }
        FileStatus[] eventDirs = fileSystem.listStatus(eventPath, EximUtil.getDirectoryFilter(fileSystem));
        if (eventDirs.length == 0) {
            return;
        }
        Arrays.sort(eventDirs, new EventDumpDirComparator());
        for (FileStatus fs : eventDirs) {
            this.getSortedFileList(fs.getPath(), fileStatuses, fileSystem);
        }
    }

    Path dbLevelPath() {
        return this.dbLevelPath;
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.databaseEventProcessed) {
                this.next = this.dbLevelPath;
                return true;
            }
            if (this.replicationState == null && this.next == null) {
                while (this.remoteIterator.hasNext()) {
                    String replacedString;
                    List filteredNames;
                    LocatedFileStatus next = (LocatedFileStatus)this.remoteIterator.next();
                    if (next.getPath().toString().endsWith("_file_list_external") || next.getPath().toString().endsWith("_tables") || !next.getPath().toString().endsWith("_metadata") || (filteredNames = Arrays.stream((replacedString = next.getPath().toString().replace(this.dbLevelPath.toString(), "")).split("/")).filter(StringUtils::isNotBlank).collect(Collectors.toList())).size() == 1) continue;
                    this.next = next.getPath().getParent();
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("could not traverse the file via remote iterator " + String.valueOf(this.dbLevelPath), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public BootstrapEvent next() {
        if (!this.databaseEventProcessed) {
            FSDatabaseEvent event = new FSDatabaseEvent(this.hiveConf, this.next.toString());
            this.databaseEventProcessed = true;
            return this.postProcessing(event);
        }
        if (this.replicationState != null) {
            return this.eventForReplicationState();
        }
        String currentPath = this.next.toString();
        if (currentPath.contains("/_functions/")) {
            LOG.debug("functions directory: {}", (Object)this.next.toString());
            return this.postProcessing(new FSFunctionEvent(this.next));
        }
        return this.postProcessing(new FSTableEvent(this.hiveConf, this.next.toString(), new Path(this.getDbLevelDataPath(), this.next.getName()).toString()));
    }

    private Path getDbLevelDataPath() {
        return new Path(new Path(this.dbLevelPath.getParent().getParent(), "data"), this.dbLevelPath.getName());
    }

    private BootstrapEvent postProcessing(BootstrapEvent bootstrapEvent) {
        this.previous = this.next;
        this.next = null;
        LOG.debug("processing " + String.valueOf(this.previous));
        return bootstrapEvent;
    }

    private BootstrapEvent eventForReplicationState() {
        if (this.replicationState.partitionState != null) {
            FSPartitionEvent bootstrapEvent = new FSPartitionEvent(this.hiveConf, this.previous.toString(), new Path(this.getDbLevelDataPath(), this.previous.getName()).toString(), this.replicationState);
            this.replicationState = null;
            return bootstrapEvent;
        }
        if (this.replicationState.lastTableReplicated != null) {
            FSTableEvent event = new FSTableEvent(this.hiveConf, this.previous.toString(), new Path(new Path(this.dbLevelPath, "data"), this.previous.getName()).toString());
            this.replicationState = null;
            return event;
        }
        throw new IllegalStateException("for replicationState " + this.replicationState.toString());
    }
}

