/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.orc.impl.OrcTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalCache
implements OrcInputFormat.FooterCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCache.class);
    private static final int DEFAULT_CACHE_INITIAL_CAPACITY = 1024;
    private final Cache<Path, TailAndFileData> cache;

    LocalCache(int numThreads, long cacheMemSize, boolean useSoftRef) {
        CacheBuilder builder = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(numThreads).maximumWeight(cacheMemSize).weigher((Weigher)new Weigher<Path, TailAndFileData>(this){

            public int weigh(Path key, TailAndFileData value) {
                return value.getMemoryUsage();
            }
        });
        if (useSoftRef) {
            builder = builder.softValues();
        }
        this.cache = builder.build();
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public void put(Path path, OrcTail tail) {
        ByteBuffer bb = tail.getSerializedTail();
        if (bb.capacity() != bb.remaining()) {
            throw new RuntimeException("Bytebuffer allocated for path: " + String.valueOf(path) + " has remaining: " + bb.remaining() + " != capacity: " + bb.capacity());
        }
        this.cache.put((Object)path, (Object)new TailAndFileData(tail.getFileTail().getFileLength(), tail.getFileModificationTime(), bb.duplicate()));
    }

    @Override
    public void getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files, boolean isOriginal, OrcTail[] result, ByteBuffer[] ppdResult) throws IOException, HiveException {
        assert (result.length == files.size());
        int i = -1;
        for (HadoopShims.HdfsFileStatusWithId fileWithId : files) {
            ++i;
            FileStatus file = fileWithId.getFileStatus();
            Path path = file.getPath();
            TailAndFileData tfd = (TailAndFileData)this.cache.getIfPresent((Object)path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serialized tail " + (tfd == null ? "not " : "") + "cached for path: " + String.valueOf(path));
            }
            if (tfd == null) continue;
            if (file.getLen() == tfd.fileLength && file.getModificationTime() == tfd.fileModTime) {
                result[i] = ReaderImpl.extractFileTail((ByteBuffer)tfd.bb.duplicate(), (long)tfd.bb.limit(), (long)tfd.fileModTime);
                continue;
            }
            this.cache.invalidate((Object)path);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Meta-Info for : " + String.valueOf(path) + " changed. CachedModificationTime: " + tfd.fileModTime + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + tfd.fileLength + ", CurrentLength: " + file.getLen());
        }
    }

    @Override
    public boolean hasPpd() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public void put(OrcInputFormat.FooterCacheKey cacheKey, OrcTail orcTail) throws IOException {
        this.put(cacheKey.getPath(), orcTail);
    }

    private static final class TailAndFileData {
        public ByteBuffer bb;
        public long fileLength;
        public long fileModTime;

        public TailAndFileData(long fileLength, long fileModificationTime, ByteBuffer bb) {
            this.fileLength = fileLength;
            this.fileModTime = fileModificationTime;
            this.bb = bb;
        }

        public int getMemoryUsage() {
            return this.bb.capacity() + 100;
        }
    }
}

