/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class AllocWriteIdHandler
extends AbstractEventHandler<AllocWriteIdMessage> {
    AllocWriteIdHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    AllocWriteIdMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getAllocWriteIdMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} ALLOC_WRITE_ID message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES)) {
            return;
        }
        if (!ReplUtils.includeAcidTableInDump(withinContext.hiveConf)) {
            return;
        }
        if (!ReplUtils.tableIncludedInReplScope(withinContext.oldReplScope, ((AllocWriteIdMessage)this.eventMessage).getTableName())) {
            return;
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_ALLOC_WRITE_ID;
    }
}

