/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateTableEvent.class);
    private String COMMAND_STR = "create table";

    public CreateTableEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.CREATETABLE, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreCreateTableEvent event = (PreCreateTableEvent)this.preEventContext;
        Table table = event.getTable();
        Database database = event.getDatabase();
        String uri = this.getSdLocation(table.getSd());
        if (StringUtils.isEmpty((CharSequence)uri)) {
            return ret;
        }
        if (this.needDFSUriAuth(uri, this.getDefaultTablePath(database, table))) {
            ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI, uri));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        LOG.debug("==> CreateTableEvent.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreCreateTableEvent event = (PreCreateTableEvent)this.preEventContext;
        Table table = event.getTable();
        Database database = event.getDatabase();
        String uri = this.getSdLocation(table.getSd());
        ret.add(this.getHivePrivilegeObject(database));
        ret.add(this.getHivePrivilegeObject(table));
        if (StringUtils.isNotEmpty((CharSequence)uri) && !MetaStoreUtils.isExternalTable((Table)table) && this.needDFSUriAuth(uri, this.getDefaultTablePath(database, table))) {
            ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI, uri));
        }
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, table);
        LOG.debug("<== CreateTableEvent.getOutputHObjs(): ret={}", ret);
        return ret;
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        Object ret = cmdStr;
        if (tbl != null) {
            String tblName = tbl.getTableName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty((CharSequence)tblName) ? " " + tblName : "");
        }
        return ret;
    }

    private String getDefaultTablePath(Database database, Table table) {
        String expectedTablePath = null;
        try {
            expectedTablePath = this.preEventContext.getHandler().getWh().getDefaultTablePath(database, table).toString();
        }
        catch (MetaException e) {
            LOG.warn("Got exception fetching Default location for dbName: {} tableName: {} ", new Object[]{database.getName(), table.getTableName(), e});
        }
        return expectedTablePath;
    }

    private boolean needDFSUriAuth(String uri, String expectedTablePath) {
        return StringUtils.isEmpty((CharSequence)expectedTablePath) || !uri.equalsIgnoreCase(expectedTablePath);
    }
}

