/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropDatabaseEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DropDatabaseEvent.class);
    private String COMMAND_STR = "drop database";

    public DropDatabaseEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.DROPDATABASE, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> DropDatabaseEvent.getInputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreDropDatabaseEvent event = (PreDropDatabaseEvent)this.preEventContext;
        Database database = event.getDatabase();
        ret.add(this.getHivePrivilegeObject(database));
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, database);
        LOG.debug("<== DropDatabaseEvent.getInputHObjs(): ret={}", ret);
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return this.getInputHObjs();
    }

    private String buildCommandString(String cmdStr, Database db) {
        Object ret = cmdStr;
        if (db != null) {
            String dbName = db.getName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty((CharSequence)dbName) ? " " + dbName : "");
        }
        return ret;
    }
}

