/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatsUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(StatsUpdater.class);

    public void gatherStats(HiveConf hiveConf, CompactionInfo ci, Map<String, String> tableProperties, String userName, String compactionQueueName, IMetaStoreClient msc) {
        try {
            Map properties;
            if (msc == null) {
                throw new IllegalArgumentException("Metastore client is missing");
            }
            HiveConf conf = this.setUpDriverSession(hiveConf, compactionQueueName, tableProperties, (Map<String, String>)new StringableMap(ci.properties));
            StringBuilder sb = new StringBuilder("analyze table ").append(StatsUtils.getFullyQualifiedTableName(ci.dbname, ci.tableName));
            if (ci.partName != null) {
                sb.append(" partition(");
                Map partitionColumnValues = Warehouse.makeEscSpecFromName((String)ci.partName);
                for (Map.Entry ent : partitionColumnValues.entrySet()) {
                    sb.append((String)ent.getKey()).append("='").append((String)ent.getValue()).append("',");
                }
                sb.setLength(sb.length() - 1);
                sb.append(")");
                Partition partition = CompactorUtil.resolvePartition(hiveConf, msc, ci.dbname, ci.tableName, ci.partName, CompactorUtil.METADATA_FETCH_MODE.REMOTE);
                properties = partition.getParameters();
            } else {
                properties = tableProperties;
            }
            sb.append(" compute statistics");
            if (ci.isMajorCompaction()) {
                List columnList = msc.findColumnsWithStats(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci)).stream().filter(columnName -> !StatsSetupConst.areColumnStatsUptoDate((Map)properties, (String)columnName)).collect(Collectors.toList());
                if (!columnList.isEmpty()) {
                    sb.append(" for columns ").append(String.join((CharSequence)",", columnList));
                } else if (StatsSetupConst.areBasicStatsUptoDate(properties)) {
                    sb.append(" noscan");
                }
            } else {
                sb.append(" noscan");
            }
            LOG.info("{}: running '{}'", (Object)ci, (Object)sb);
            SessionState sessionState = DriverUtils.setUpAndStartSessionState(conf, userName);
            DriverUtils.runOnDriver(conf, sessionState, sb.toString());
        }
        catch (Throwable t) {
            LOG.error("{}: gatherStats({},{},{}) failed due to: {}", new Object[]{ci, ci.dbname, ci.tableName, ci.partName, t.getMessage(), t});
        }
    }

    HiveConf setUpDriverSession(HiveConf sourceConf, String compactionQueueName, Map<String, String> tableProperties, Map<String, String> ciProperties) {
        HiveConf conf = new HiveConf(sourceConf);
        conf.unset("hive.txn.valid.txns");
        CompactorUtil.overrideConfProps(conf, ciProperties, tableProperties);
        if (StringUtils.isNotBlank((CharSequence)compactionQueueName)) {
            conf.set("tez.queue.name", compactionQueueName);
        }
        return conf;
    }
}

