/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

public abstract class CompactSketch
extends Sketch {
    private final short seedHash_;
    private final boolean empty_;
    private final int curCount_;
    private final long thetaLong_;

    CompactSketch(boolean empty, short seedHash, int curCount, long thetaLong) {
        this.empty_ = empty;
        this.seedHash_ = seedHash;
        this.curCount_ = curCount;
        this.thetaLong_ = thetaLong;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    int getPreambleLongs() {
        return CompactSketch.compactPreambleLongs(this.getThetaLong(), this.isEmpty());
    }

    static final long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final long[] compactCachePart(long[] srcCache, int lgArrLongs, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = 1 << lgArrLongs;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        assert (curCount == j);
        if (dstOrdered) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final CompactSketch createCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, boolean dstOrdered, Memory dstMem) {
        CompactSketch sketchOut = null;
        int sw = (dstOrdered ? 2 : 0) | (dstMem != null ? 1 : 0);
        switch (sw) {
            case 0: {
                sketchOut = new HeapCompactSketch(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 1: {
                sketchOut = new DirectCompactSketch(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
                break;
            }
            case 2: {
                sketchOut = new HeapCompactOrderedSketch(compactCache, empty, seedHash, curCount, thetaLong);
                break;
            }
            case 3: {
                sketchOut = new DirectCompactOrderedSketch(compactCache, empty, seedHash, curCount, thetaLong, dstMem);
            }
        }
        return sketchOut;
    }

    static final Memory loadCompactMemory(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong, Memory dstMem, byte flags) {
        int dstBytes;
        int preLongs = CompactSketch.compactPreambleLongs(thetaLong, empty);
        int outLongs = preLongs + curCount;
        int outBytes = outLongs << 3;
        if (outBytes > (dstBytes = (int)dstMem.getCapacity())) {
            throw new SketchesArgumentException("Insufficient Memory: " + dstBytes + ", Need: " + outBytes);
        }
        byte famID = (byte)Family.stringToFamily("Compact").getID();
        Object memObj = dstMem.array();
        long memAdd = dstMem.getCumulativeOffset(0L);
        PreambleUtil.insertPreLongs(memObj, memAdd, preLongs);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, famID);
        PreambleUtil.insertFlags(memObj, memAdd, flags);
        PreambleUtil.insertSeedHash(memObj, memAdd, seedHash);
        if (preLongs > 1) {
            PreambleUtil.insertCurCount(memObj, memAdd, curCount);
            PreambleUtil.insertP(memObj, memAdd, 1.0f);
        }
        if (preLongs > 2) {
            PreambleUtil.insertThetaLong(memObj, memAdd, thetaLong);
        }
        if (compactCache != null && curCount > 0) {
            dstMem.putLongArray((long)(preLongs << 3), compactCache, 0, curCount);
        }
        return dstMem;
    }
}

