/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.openid;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum OpenIdError {
    INCORRECT_OPENID_SCOPES,
    OTHER;


    static class Serializer
    extends UnionSerializer<OpenIdError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(OpenIdError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INCORRECT_OPENID_SCOPES: {
                    g.writeString("incorrect_openid_scopes");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public OpenIdError deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            OpenIdError value = "incorrect_openid_scopes".equals(tag) ? INCORRECT_OPENID_SCOPES : OTHER;
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

