/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformData;

public abstract class SalesforceTransformMeta<Main extends SalesforceTransform, Data extends SalesforceTransformData>
extends BaseTransformMeta<Main, Data> {
    private static final Class<?> PKG = SalesforceTransformMeta.class;
    @HopMetadataProperty(key="targetUrl", injectionKey="SALESFORCE_URL")
    private String targetUrl;
    @HopMetadataProperty(key="username", injectionKey="SALESFORCE_USERNAME")
    private String username;
    @HopMetadataProperty(key="password", injectionKey="SALESFORCE_PASSWOR", password=true)
    private String password;
    @HopMetadataProperty(key="timeout", injectionKey="TIME_OUT")
    private String timeout;
    @HopMetadataProperty(key="useCompression", injectionKey="USE_COMPRESSION")
    private boolean compression;
    @HopMetadataProperty(key="module", injectionKey="MODULE")
    private String module;
    @HopMetadataProperty(key="salesforce_connection", injectionKey="SALESFORCE_CONNECTION")
    private String salesforceConnection;

    public Object clone() {
        SalesforceTransformMeta retval = (SalesforceTransformMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.setTargetUrl("https://login.salesforce.com/services/Soap/u/64.0");
        this.setUsername("");
        this.setPassword("");
        this.setTimeout("60000");
        this.setCompression(false);
        this.setModule("Account");
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.getTargetUrl()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.NoURL", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.URLOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.getUsername()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.NoUsername", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.UsernameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.getModule()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.NoModule", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceTransformMeta.CheckResult.ModuleOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    @Generated
    public String getTargetUrl() {
        return this.targetUrl;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isCompression() {
        return this.compression;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public String getSalesforceConnection() {
        return this.salesforceConnection;
    }

    @Generated
    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setSalesforceConnection(String salesforceConnection) {
        this.salesforceConnection = salesforceConnection;
    }
}

