/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.TwoWayPasswordEncoderPluginType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.extension.ExtensionPointPluginType;
import org.apache.hop.core.logging.ConsoleLoggingEventListener;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingPlugin;
import org.apache.hop.core.logging.LoggingPluginType;
import org.apache.hop.core.logging.Slf4jLoggingEventListener;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.value.ValueMetaPluginType;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.variables.resolver.VariableResolverPluginType;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.vfs.plugin.VfsPluginType;

public class HopClientEnvironment {
    private static final Class<?> PKG = Const.class;
    private static HopClientEnvironment instance = null;
    private static Boolean initialized;
    private ClientType client;
    private String clientID = null;

    public static synchronized void init() throws HopException {
        HopClientEnvironment.init(List.of(LoggingPluginType.getInstance(), ValueMetaPluginType.getInstance(), DatabasePluginType.getInstance(), ExtensionPointPluginType.getInstance(), TwoWayPasswordEncoderPluginType.getInstance(), VariableResolverPluginType.getInstance(), VfsPluginType.getInstance()));
    }

    public static synchronized void init(List<IPluginType> pluginsToLoad) throws HopException {
        if (initialized != null) {
            return;
        }
        if (instance == null) {
            instance = new HopClientEnvironment();
        }
        HopLogStore.init();
        if (!"Y".equalsIgnoreCase(System.getProperty("HOP_DISABLE_CONSOLE_LOGGING", "N"))) {
            HopLogStore.getAppender().addLoggingEventListener(new ConsoleLoggingEventListener());
        }
        HopLogStore.getAppender().addLoggingEventListener(new Slf4jLoggingEventListener());
        pluginsToLoad.forEach(PluginRegistry::addPluginType);
        PluginRegistry.init();
        List<IPlugin> loggingPlugins = PluginRegistry.getInstance().getPlugins(LoggingPluginType.class);
        HopClientEnvironment.initLogginPlugins(loggingPlugins);
        String passwordEncoderPluginID = Const.NVL(EnvUtil.getSystemProperty("HOP_PASSWORD_ENCODER_PLUGIN"), "Hop");
        Encr.init(passwordEncoderPluginID);
        HopVfs.reset();
        initialized = true;
    }

    protected static final List<Field> findDeclaredFields(Class<?> parentClass) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Field field : parentClass.getDeclaredFields()) {
            fields.add(field);
        }
        for (Class<?> superClass = parentClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Field field : superClass.getDeclaredFields()) {
                fields.add(field);
            }
        }
        return new ArrayList<Field>(fields);
    }

    protected static final List<Method> findDeclaredMethods(Class<?> parentClass) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Method method : parentClass.getDeclaredMethods()) {
            methods.add(method);
        }
        for (Class<?> superClass = parentClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Method method : superClass.getDeclaredMethods()) {
                methods.add(method);
            }
        }
        return new ArrayList<Method>(methods);
    }

    public static boolean isInitialized() {
        return initialized != null;
    }

    private static void initLogginPlugins(List<IPlugin> logginPlugins) throws HopPluginException {
        for (IPlugin plugin : logginPlugins) {
            ILoggingPlugin loggingPlugin = (ILoggingPlugin)PluginRegistry.getInstance().loadClass(plugin);
            loggingPlugin.init();
        }
    }

    public void setClient(ClientType client) {
        this.client = client;
    }

    public void setClientID(String id) {
        this.clientID = id;
    }

    public ClientType getClient() {
        return this.client;
    }

    public static HopClientEnvironment getInstance() {
        if (instance == null) {
            instance = new HopClientEnvironment();
        }
        return instance;
    }

    public static void reset() {
        if (HopLogStore.isInitialized()) {
            HopLogStore.getInstance().reset();
        }
        PluginRegistry.getInstance().reset();
        initialized = null;
    }

    public static enum ClientType {
        HOP_GUI,
        CLI,
        SERVER,
        OTHER;


        public String getID() {
            if (this != OTHER) {
                return this.name();
            }
            return HopClientEnvironment.instance.clientID;
        }
    }
}

