/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.StorageService;

public class Datacenters {
    public static String thisDatacenter() {
        return DCHandle.thisDc;
    }

    public static Set<String> getValidDatacenters() {
        HashSet<String> validDataCenters = new HashSet<String>();
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        validDataCenters.add(Datacenters.thisDatacenter());
        for (InetAddressAndPort peer : StorageService.instance.getTokenMetadata().getAllEndpoints()) {
            validDataCenters.add(snitch.getDatacenter(peer));
        }
        return validDataCenters;
    }

    private static class DCHandle {
        private static final String thisDc = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();

        private DCHandle() {
        }
    }
}

