/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.plugin.IVfs;
import org.apache.hop.core.vfs.plugin.VfsPlugin;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.vfs.gs.GoogleStorageFileProvider;
import org.apache.hop.vfs.gs.metadatatype.GoogleStorageMetadataType;

@VfsPlugin(type="gs", typeDescription="Google Storage VFS", classLoaderGroup="vfs-google")
public class GoogleStorageVfsPlugin
implements IVfs {
    public String[] getUrlSchemes() {
        return new String[]{"gs"};
    }

    public FileProvider getProvider() {
        return new GoogleStorageFileProvider();
    }

    public Map<String, FileProvider> getProviders(IVariables variables) {
        HashMap<String, FileProvider> providers = new HashMap<String, FileProvider>();
        try {
            MultiMetadataProvider metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)variables);
            List googleStorageMetadataTypes = metadataProvider.getSerializer(GoogleStorageMetadataType.class).loadAll();
            for (GoogleStorageMetadataType googleStorageMetadataType : googleStorageMetadataTypes) {
                providers.put(googleStorageMetadataType.getName(), (FileProvider)new GoogleStorageFileProvider(variables, googleStorageMetadataType));
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Unable to load Google Storage VFS providers", (Throwable)e);
        }
        return providers;
    }
}

