/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileNameParser;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));

    public ResourceFileProvider() {
        this.setFileNameParser(ResourceFileNameParser.getInstance());
    }

    @Override
    public void closeFileSystem(FileSystem filesystem) {
    }

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName fileName = baseFile != null ? this.parseUri(baseFile.getName(), uri) : this.parseUri(null, uri);
        String resourceName = fileName.getPath();
        ClassLoader classLoader = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        FileSystemException.requireNonNull(classLoader, "vfs.provider.url/badly-formed-uri.error", uri);
        URL url = classLoader.getResource(resourceName);
        FileSystemException.requireNonNull(url, "vfs.provider.url/badly-formed-uri.error", uri);
        return this.getContext().getFileSystemManager().resolveFile(url.toExternalForm());
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }
}

