/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextContinueNumberingAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextListIdAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartValueAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextNumberedParagraphElement
extends OdfStylableElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "numbered-paragraph");

    public TextNumberedParagraphElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.List, OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public Boolean getTextContinueNumberingAttribute() {
        TextContinueNumberingAttribute attr = (TextContinueNumberingAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "continue-numbering");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextContinueNumberingAttribute(Boolean textContinueNumberingValue) {
        TextContinueNumberingAttribute attr = new TextContinueNumberingAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textContinueNumberingValue);
    }

    public Integer getTextLevelAttribute() {
        TextLevelAttribute attr = (TextLevelAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "level");
        if (attr != null) {
            return attr.intValue();
        }
        return Integer.valueOf("1");
    }

    public void setTextLevelAttribute(Integer textLevelValue) {
        TextLevelAttribute attr = new TextLevelAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textLevelValue);
    }

    public String getTextListIdAttribute() {
        TextListIdAttribute attr = (TextListIdAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "list-id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextListIdAttribute(String textListIdValue) {
        TextListIdAttribute attr = new TextListIdAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textListIdValue);
    }

    public Integer getTextStartValueAttribute() {
        TextStartValueAttribute attr = (TextStartValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "start-value");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextStartValueAttribute(Integer textStartValueValue) {
        TextStartValueAttribute attr = new TextStartValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textStartValueValue);
    }

    public String getTextStyleNameAttribute() {
        TextStyleNameAttribute attr = (TextStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStyleNameAttribute(String textStyleNameValue) {
        TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStyleNameValue);
    }

    public String getXmlIdAttribute() {
        XmlIdAttribute attr = (XmlIdAttribute)this.getOdfAttribute(OdfDocumentNamespace.XML, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setXmlIdAttribute(String xmlIdValue) {
        XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xmlIdValue);
    }

    public TextHElement newTextHElement(int textOutlineLevelValue) {
        TextHElement textH = ((OdfFileDom)this.ownerDocument).newOdfElement(TextHElement.class);
        textH.setTextOutlineLevelAttribute(textOutlineLevelValue);
        this.appendChild((Node)((Object)textH));
        return textH;
    }

    public TextNumberElement newTextNumberElement() {
        TextNumberElement textNumber = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNumberElement.class);
        this.appendChild((Node)((Object)textNumber));
        return textNumber;
    }

    public TextPElement newTextPElement() {
        TextPElement textP = ((OdfFileDom)this.ownerDocument).newOdfElement(TextPElement.class);
        this.appendChild((Node)((Object)textP));
        return textP;
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

