/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopConfigException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Value;

@HopMetadata(key="neo4j-connection", name="i18n::NeoConnection.name", description="i18n::NeoConnection.description", image="neo4j_logo.svg", documentationUrl="/metadata-types/neo4j/neo4j-connection.html", hopMetadataPropertyType=HopMetadataPropertyType.GRAPH_CONNECTION)
public class NeoConnection
extends HopMetadataBase
implements IHopMetadata {
    @HopMetadataProperty
    private String server;
    @HopMetadataProperty
    private String databaseName;
    @HopMetadataProperty
    private String boltPort;
    @HopMetadataProperty
    private String browserPort;
    @HopMetadataProperty
    private boolean routing;
    @HopMetadataProperty
    private String routingVariable;
    @HopMetadataProperty
    private String routingPolicy;
    @HopMetadataProperty
    private String username;
    @HopMetadataProperty(password=true)
    private String password;
    @HopMetadataProperty
    private boolean usingEncryption;
    @HopMetadataProperty
    private String usingEncryptionVariable;
    @HopMetadataProperty
    private boolean trustAllCertificates;
    @HopMetadataProperty
    private String trustAllCertificatesVariable;
    @HopMetadataProperty
    private List<String> manualUrls;
    @HopMetadataProperty
    private String connectionLivenessCheckTimeout;
    @HopMetadataProperty
    private String maxConnectionLifetime;
    @HopMetadataProperty
    private String maxConnectionPoolSize;
    @HopMetadataProperty
    private String connectionAcquisitionTimeout;
    @HopMetadataProperty
    private String connectionTimeout;
    @HopMetadataProperty
    private String maxTransactionRetryTime;
    @HopMetadataProperty
    private boolean version4;
    @HopMetadataProperty
    private String version4Variable;
    @HopMetadataProperty
    private boolean automatic;
    @HopMetadataProperty
    private String automaticVariable;
    @HopMetadataProperty
    private String protocol;

    public NeoConnection() {
        this.boltPort = "7687";
        this.browserPort = "7474";
        this.protocol = "neo4j";
        this.manualUrls = new ArrayList<String>();
        this.version4 = true;
        this.automatic = true;
    }

    public NeoConnection(NeoConnection source) {
        this.name = source.name;
        this.server = source.server;
        this.boltPort = source.boltPort;
        this.browserPort = source.browserPort;
        this.routing = source.routing;
        this.routingVariable = source.routingVariable;
        this.routingPolicy = source.routingPolicy;
        this.username = source.username;
        this.password = source.password;
        this.usingEncryption = source.usingEncryption;
        this.usingEncryptionVariable = source.usingEncryptionVariable;
        this.trustAllCertificates = source.trustAllCertificates;
        this.trustAllCertificatesVariable = source.trustAllCertificatesVariable;
        this.connectionLivenessCheckTimeout = source.connectionLivenessCheckTimeout;
        this.maxConnectionLifetime = source.maxConnectionLifetime;
        this.maxConnectionPoolSize = source.maxConnectionPoolSize;
        this.connectionAcquisitionTimeout = source.connectionAcquisitionTimeout;
        this.connectionTimeout = source.connectionTimeout;
        this.maxTransactionRetryTime = source.maxTransactionRetryTime;
        this.version4 = source.version4;
        this.version4Variable = source.version4Variable;
        this.automatic = source.automatic;
        this.automaticVariable = source.automaticVariable;
        this.protocol = source.protocol;
        this.manualUrls = new ArrayList<String>();
        this.manualUrls.addAll(source.manualUrls);
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NeoConnection)) {
            return false;
        }
        NeoConnection connection = (NeoConnection)((Object)object);
        return this.name != null && this.name.equalsIgnoreCase(connection.name);
    }

    public Session getSession(ILogChannel log, Driver driver, IVariables variables) {
        String realDatabaseName;
        SessionConfig.Builder cfgBuilder = SessionConfig.builder();
        if (StringUtils.isNotEmpty((String)this.databaseName) && StringUtils.isNotEmpty((String)(realDatabaseName = variables.resolve(this.databaseName)))) {
            cfgBuilder.withDatabase(realDatabaseName);
        }
        return driver.session(cfgBuilder.build());
    }

    public void test(IVariables variables) throws HopException {
        try (Driver driver = this.getDriver(LogChannel.GENERAL, variables);){
            SessionConfig.Builder builder = SessionConfig.builder();
            if (StringUtils.isNotEmpty((String)this.databaseName)) {
                builder = builder.withDatabase(variables.resolve(this.databaseName));
            }
            try (Session session = driver.session(builder.build());){
                Result result = session.run("RETURN 0");
                Record record = result.next();
                Value value = record.get(0);
                int zero = value.asInt();
                assert (zero == 0);
            }
            catch (Exception e) {
                throw new HopException("Unable to connect to database '" + this.name + "' : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<URI> getURIs(IVariables variables) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (!Utils.isEmpty(this.manualUrls)) {
            for (String manualUrl : this.manualUrls) {
                uris.add(new URI(manualUrl));
            }
        } else {
            ArrayList<String> serverStrings = new ArrayList<String>();
            String serversString = variables.resolve(this.server);
            if (!this.isAutomatic(variables) && this.isUsingRouting(variables)) {
                Collections.addAll(serverStrings, serversString.split(","));
            } else {
                serverStrings.add(serversString);
            }
            for (String serverString : serverStrings) {
                String url = this.getUrl(Const.trim((String)serverString), variables);
                uris.add(new URI(url));
            }
        }
        return uris;
    }

    public String getUrl(String hostname, IVariables variables) {
        Object url = "";
        url = StringUtils.isEmpty((String)this.protocol) ? (this.isAutomatic(variables) || this.isUsingRouting(variables) ? (String)url + "neo4j" : (String)url + "bolt") : (String)url + variables.resolve(this.protocol);
        url = (String)url + "://";
        url = (String)url + hostname;
        if (StringUtils.isNotEmpty((String)this.boltPort) && hostname != null && !hostname.contains(":")) {
            url = (String)url + ":" + variables.resolve(this.boltPort);
        }
        String routingPolicyString = variables.resolve(this.routingPolicy);
        if (!this.isAutomatic(variables) && this.isUsingRouting(variables) && StringUtils.isNotEmpty((String)routingPolicyString)) {
            try {
                url = (String)url + "?policy=" + URLEncoder.encode(routingPolicyString, "UTF-8");
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error encoding routing policy context '" + routingPolicyString + "' in connection URL", (Throwable)e);
                url = (String)url + "?policy=" + routingPolicyString;
            }
        }
        return url;
    }

    public String getUrl(IVariables variables) {
        StringBuffer urls = new StringBuffer();
        try {
            for (URI uri : this.getURIs(variables)) {
                if (!urls.isEmpty()) {
                    urls.append(",");
                }
                urls.append(uri.toString());
            }
        }
        catch (Exception e) {
            urls.append("ERROR building URLs: " + e.getMessage());
        }
        return urls.toString();
    }

    public boolean encryptionVariableSet(IVariables variables) {
        String value;
        if (!Utils.isEmpty((CharSequence)this.usingEncryptionVariable) && !Utils.isEmpty((CharSequence)(value = variables.resolve(this.usingEncryptionVariable)))) {
            return ValueMetaBase.convertStringToBoolean((String)value);
        }
        return false;
    }

    public boolean trustAllCertificatesVariableSet(IVariables variables) {
        String value;
        if (!Utils.isEmpty((CharSequence)this.trustAllCertificatesVariable) && !Utils.isEmpty((CharSequence)(value = variables.resolve(this.trustAllCertificatesVariable)))) {
            return ValueMetaBase.convertStringToBoolean((String)value);
        }
        return false;
    }

    public Driver getDriver(ILogChannel log, IVariables variables) throws HopConfigException {
        try {
            long seconds;
            long seconds2;
            long seconds3;
            int size;
            long seconds4;
            Config.ConfigBuilder configBuilder;
            List<URI> uris = this.getURIs(variables);
            String realUsername = variables.resolve(this.username);
            String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)variables.resolve(this.password));
            if (!this.isAutomatic(variables)) {
                if (this.encryptionVariableSet(variables) || this.usingEncryption) {
                    configBuilder = Config.builder().withEncryption();
                    if (this.trustAllCertificatesVariableSet(variables) || this.trustAllCertificates) {
                        configBuilder = configBuilder.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
                    }
                } else {
                    configBuilder = Config.builder().withoutEncryption();
                }
            } else {
                configBuilder = Config.builder();
            }
            if (StringUtils.isNotEmpty((String)this.connectionLivenessCheckTimeout) && (seconds4 = Const.toLong((String)variables.resolve(this.connectionLivenessCheckTimeout), (long)-1L)) > 0L) {
                configBuilder = configBuilder.withConnectionLivenessCheckTimeout(seconds4, TimeUnit.MILLISECONDS);
            }
            if (StringUtils.isNotEmpty((String)this.maxConnectionLifetime) && (seconds4 = Const.toLong((String)variables.resolve(this.maxConnectionLifetime), (long)-1L)) > 0L) {
                configBuilder = configBuilder.withMaxConnectionLifetime(seconds4, TimeUnit.MILLISECONDS);
            }
            if (StringUtils.isNotEmpty((String)this.maxConnectionPoolSize) && (size = Const.toInt((String)variables.resolve(this.maxConnectionPoolSize), (int)-1)) > 0) {
                configBuilder = configBuilder.withMaxConnectionPoolSize(size);
            }
            if (StringUtils.isNotEmpty((String)this.connectionAcquisitionTimeout) && (seconds3 = Const.toLong((String)variables.resolve(this.connectionAcquisitionTimeout), (long)-1L)) > 0L) {
                configBuilder = configBuilder.withConnectionAcquisitionTimeout(seconds3, TimeUnit.MILLISECONDS);
            }
            if (StringUtils.isNotEmpty((String)this.connectionTimeout) && (seconds2 = Const.toLong((String)variables.resolve(this.connectionTimeout), (long)-1L)) > 0L) {
                configBuilder = configBuilder.withConnectionTimeout(seconds2, TimeUnit.MILLISECONDS);
            }
            if (StringUtils.isNotEmpty((String)this.maxTransactionRetryTime) && (seconds = Const.toLong((String)variables.resolve(this.maxTransactionRetryTime), (long)-1L)) >= 0L) {
                configBuilder = configBuilder.withMaxTransactionRetryTime(seconds, TimeUnit.MILLISECONDS);
            }
            configBuilder = configBuilder.withLogging(Logging.javaUtilLogging((Level)Level.WARNING));
            Config config = configBuilder.build();
            Driver driver = this.isUsingRouting(variables) ? GraphDatabase.routingDriver(uris, (AuthToken)AuthTokens.basic((String)realUsername, (String)realPassword), (Config)config) : GraphDatabase.driver((URI)uris.get(0), (AuthToken)AuthTokens.basic((String)realUsername, (String)realPassword), (Config)config);
            driver.verifyConnectivity();
            return driver;
        }
        catch (URISyntaxException e) {
            throw new HopConfigException("URI syntax problem, check your settings, hostnames especially.  For routing use comma separated server values.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HopConfigException("Error obtaining driver for a Neo4j connection", (Throwable)e);
        }
    }

    public boolean isUsingRouting(IVariables variables) {
        String value;
        if (!Utils.isEmpty((CharSequence)this.routingVariable) && !Utils.isEmpty((CharSequence)(value = variables.resolve(this.routingVariable)))) {
            return ValueMetaBase.convertStringToBoolean((String)value);
        }
        return this.routing;
    }

    public boolean isAutomatic(IVariables variables) {
        if (StringUtils.isEmpty((String)this.automaticVariable)) {
            return this.isAutomatic();
        }
        String automaticString = variables.resolve(this.automaticVariable);
        Boolean auto = ValueMetaBase.convertStringToBoolean((String)automaticString);
        return auto != null && auto != false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getBoltPort() {
        return this.boltPort;
    }

    public void setBoltPort(String boltPort) {
        this.boltPort = boltPort;
    }

    public String getBrowserPort() {
        return this.browserPort;
    }

    public void setBrowserPort(String browserPort) {
        this.browserPort = browserPort;
    }

    public boolean isRouting() {
        return this.routing;
    }

    public void setRouting(boolean routing) {
        this.routing = routing;
    }

    public String getRoutingVariable() {
        return this.routingVariable;
    }

    public void setRoutingVariable(String routingVariable) {
        this.routingVariable = routingVariable;
    }

    public String getRoutingPolicy() {
        return this.routingPolicy;
    }

    public void setRoutingPolicy(String routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUsingEncryption() {
        return this.usingEncryption;
    }

    public void setUsingEncryption(boolean usingEncryption) {
        this.usingEncryption = usingEncryption;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public List<String> getManualUrls() {
        return this.manualUrls;
    }

    public void setManualUrls(List<String> manualUrls) {
        this.manualUrls = manualUrls;
    }

    public String getConnectionLivenessCheckTimeout() {
        return this.connectionLivenessCheckTimeout;
    }

    public void setConnectionLivenessCheckTimeout(String connectionLivenessCheckTimeout) {
        this.connectionLivenessCheckTimeout = connectionLivenessCheckTimeout;
    }

    public String getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    public void setMaxConnectionLifetime(String maxConnectionLifetime) {
        this.maxConnectionLifetime = maxConnectionLifetime;
    }

    public String getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public void setMaxConnectionPoolSize(String maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
    }

    public String getConnectionAcquisitionTimeout() {
        return this.connectionAcquisitionTimeout;
    }

    public void setConnectionAcquisitionTimeout(String connectionAcquisitionTimeout) {
        this.connectionAcquisitionTimeout = connectionAcquisitionTimeout;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getMaxTransactionRetryTime() {
        return this.maxTransactionRetryTime;
    }

    public void setMaxTransactionRetryTime(String maxTransactionRetryTime) {
        this.maxTransactionRetryTime = maxTransactionRetryTime;
    }

    public boolean isVersion4() {
        return this.version4;
    }

    public void setVersion4(boolean version4) {
        this.version4 = version4;
    }

    public String getUsingEncryptionVariable() {
        return this.usingEncryptionVariable;
    }

    public void setUsingEncryptionVariable(String usingEncryptionVariable) {
        this.usingEncryptionVariable = usingEncryptionVariable;
    }

    public String getTrustAllCertificatesVariable() {
        return this.trustAllCertificatesVariable;
    }

    public void setTrustAllCertificatesVariable(String trustAllCertificatesVariable) {
        this.trustAllCertificatesVariable = trustAllCertificatesVariable;
    }

    public String getVersion4Variable() {
        return this.version4Variable;
    }

    public void setVersion4Variable(String version4Variable) {
        this.version4Variable = version4Variable;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    public String getAutomaticVariable() {
        return this.automaticVariable;
    }

    public void setAutomaticVariable(String automaticVariable) {
        this.automaticVariable = automaticVariable;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

