/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.List;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SelectRowDialog
extends Dialog {
    private static final Class<?> PKG = SelectRowDialog.class;
    private Label wlFields;
    private TableView wFields;
    private Shell shell;
    private List<RowMetaAndData> buffer;
    private PropsUi props;
    private String title;
    private RowMetaAndData selection;
    private IVariables variables;

    public SelectRowDialog(Shell parent, IVariables variables, int style, List<RowMetaAndData> buffer) {
        super(parent, style);
        this.buffer = buffer;
        this.variables = variables;
        this.props = PropsUi.getInstance();
        this.selection = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RowMetaAndData open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3184);
        PropsUi.setLook((Widget)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        if (this.title == null) {
            this.title = BaseMessages.getString(PKG, (String)"SelectRowDialog.Title", (String[])new String[0]);
        }
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        this.shell.setText(this.title);
        int margin = PropsUi.getMargin();
        if (Utils.isEmpty(this.buffer)) {
            return null;
        }
        IRowMeta rowMeta = this.buffer.get(0).getRowMeta();
        int fieldsRows = this.buffer.size();
        ColumnInfo[] colinf = new ColumnInfo[rowMeta.size()];
        for (int i = 0; i < rowMeta.size(); ++i) {
            IValueMeta v = rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, false);
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setReadOnly(true);
        }
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, fieldsRows, null, this.props);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, margin, null);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wOk, -margin);
        this.wFields.setLayoutData(fdFields);
        wOk.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.close());
        this.wFields.table.addListener(14, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.close());
        return this.selection;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void getData() {
        for (int i = 0; i < this.buffer.size(); ++i) {
            RowMetaAndData rowMetaAndData = this.buffer.get(i);
            IRowMeta rowMeta = rowMetaAndData.getRowMeta();
            Object[] rowData = rowMetaAndData.getData();
            for (int c = 0; c < rowMeta.size(); ++c) {
                String show;
                IValueMeta v = rowMeta.getValueMeta(c);
                try {
                    show = v.isNumeric() ? v.getString(rowData[c]) : v.getString(rowData[c]);
                }
                catch (HopValueException e) {
                    show = "<conversion error>";
                }
                if (show == null) continue;
                this.wFields.table.getItem(i).setText(c + 1, show);
            }
        }
        this.wFields.optWidth(true);
    }

    private void close() {
        this.selection = null;
        this.dispose();
    }

    private void ok() {
        int[] idx = this.wFields.getSelectionIndices();
        if (idx.length > 0 && idx[0] < this.buffer.size()) {
            this.selection = this.buffer.get(idx[0]);
        }
        this.dispose();
    }
}

