/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.errorhandling;

import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.errorhandling.AbstractFileErrorHandler;

public class FileErrorHandlerMissingFiles
extends AbstractFileErrorHandler {
    private static final Class<?> PKG = FileErrorHandlerMissingFiles.class;
    public static final String THIS_FILE_DOES_NOT_EXIST = BaseMessages.getString(PKG, (String)"FileErrorHandlerMissingFiles.FILE_DOES_NOT_EXIST", (String[])new String[0]);
    public static final String THIS_FILE_WAS_NOT_ACCESSIBLE = BaseMessages.getString(PKG, (String)"FileErrorHandlerMissingFiles.FILE_WAS_NOT_ACCESSIBLE", (String[])new String[0]);

    public FileErrorHandlerMissingFiles(Date date, String destinationDirectory, String fileExtension, String encoding, BaseTransform baseTransform) {
        super(date, destinationDirectory, fileExtension, encoding, baseTransform);
    }

    @Override
    public void handleLineError(long lineNr, String filePart) {
    }

    @Override
    public void handleNonExistantFile(FileObject file) throws HopException {
        this.handleFile(file);
        try {
            this.getWriter("NO_PARTS").write(THIS_FILE_DOES_NOT_EXIST);
            this.getWriter("NO_PARTS").write(Const.CR);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"FileErrorHandlerMissingFiles.Exception.CouldNotCreateNonExistantFile", (String[])new String[0]) + file.getName().getURI(), (Throwable)e);
        }
    }

    @Override
    public void handleNonAccessibleFile(FileObject file) throws HopException {
        this.handleFile(file);
        try {
            this.getWriter("NO_PARTS").write(THIS_FILE_WAS_NOT_ACCESSIBLE);
            this.getWriter("NO_PARTS").write(Const.CR);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"FileErrorHandlerMissingFiles.Exception.CouldNotCreateNonAccessibleFile", (String[])new String[0]) + file.getName().getURI(), (Throwable)e);
        }
    }
}

