/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class EncodedValueComparator
extends TypeComparator<byte[]> {
    private transient @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedReferenceKey;
    private final @UnknownKeyFor @NonNull @Initialized boolean ascending;

    public EncodedValueComparator(@UnknownKeyFor @NonNull @Initialized boolean ascending) {
        this.ascending = ascending;
    }

    public @UnknownKeyFor @NonNull @Initialized int hash(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] record) {
        return Arrays.hashCode(record);
    }

    public void setReference(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toCompare) {
        this.encodedReferenceKey = toCompare;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean equalToReference(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] candidate) {
        if (this.encodedReferenceKey.length != candidate.length) {
            return false;
        }
        int len = candidate.length;
        for (int i = 0; i < len; ++i) {
            if (this.encodedReferenceKey[i] == candidate[i]) continue;
            return false;
        }
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized int compareToReference(@UnknownKeyFor @NonNull @Initialized TypeComparator<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> other) {
        EncodedValueComparator otherEncodedValueComparator = (EncodedValueComparator)other;
        int len = Math.min(this.encodedReferenceKey.length, otherEncodedValueComparator.encodedReferenceKey.length);
        for (int i = 0; i < len; ++i) {
            int result;
            byte b1 = this.encodedReferenceKey[i];
            byte b2 = otherEncodedValueComparator.encodedReferenceKey[i];
            int n = b1 < b2 ? -1 : (result = b1 == b2 ? 0 : 1);
            if (result == 0) continue;
            return this.ascending ? -result : result;
        }
        int result = this.encodedReferenceKey.length - otherEncodedValueComparator.encodedReferenceKey.length;
        return this.ascending ? -result : result;
    }

    public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] first, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] second) {
        int len = Math.min(first.length, second.length);
        for (int i = 0; i < len; ++i) {
            int result;
            byte b1 = first[i];
            byte b2 = second[i];
            int n = b1 < b2 ? -1 : (result = b1 == b2 ? 0 : 1);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        int result = first.length - second.length;
        return this.ascending ? result : -result;
    }

    public @UnknownKeyFor @NonNull @Initialized int compareSerialized(@UnknownKeyFor @NonNull @Initialized DataInputView firstSource, @UnknownKeyFor @NonNull @Initialized DataInputView secondSource) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int lengthFirst = firstSource.readInt();
        int lengthSecond = secondSource.readInt();
        int len = Math.min(lengthFirst, lengthSecond);
        for (int i = 0; i < len; ++i) {
            int result;
            byte b2;
            byte b1 = firstSource.readByte();
            int n = b1 < (b2 = secondSource.readByte()) ? -1 : (result = b1 == b2 ? 0 : 1);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        int result = lengthFirst - lengthSecond;
        return this.ascending ? result : -result;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean supportsNormalizedKey() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isNormalizedKeyPrefixOnly(@UnknownKeyFor @NonNull @Initialized int keyBytes) {
        return true;
    }

    public void putNormalizedKey(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] record, @UnknownKeyFor @NonNull @Initialized MemorySegment target, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int numBytes) {
        int limit = offset + numBytes;
        target.put(offset, record, 0, Math.min(numBytes, record.length));
        offset += record.length;
        while (offset < limit) {
            target.put(offset++, (byte)0);
        }
    }

    public void writeWithKeyNormalization(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] record, @UnknownKeyFor @NonNull @Initialized DataOutputView target) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readWithKeyDenormalization(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] reuse, @UnknownKeyFor @NonNull @Initialized DataInputView source) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean invertNormalizedKey() {
        return !this.ascending;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeComparator<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> duplicate() {
        return new EncodedValueComparator(this.ascending);
    }

    public @UnknownKeyFor @NonNull @Initialized int extractKeys(@UnknownKeyFor @NonNull @Initialized Object record, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] target, @UnknownKeyFor @NonNull @Initialized int index) {
        target[index] = record;
        return 1;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeComparator @UnknownKeyFor @NonNull @Initialized [] getFlatComparators() {
        return new TypeComparator[]{this.duplicate()};
    }
}

